#!/bin/bash
echo "Running simulations..."

# Define the directory containing your sim_config files (do both c0 for cluster 0 and c1 for cluster 1)
config_dir="config/master_config_c0" 
echo "Configuration directory: $config_dir"

# Loop through each sim_config file in the directory
for sim_config_file in "$config_dir"/sim_config*.json; do
    echo "Running simulation with config: $sim_config_file"

    # Start a new tmux session for each simulation
    tmux new-session -d -s "$(basename "$sim_config_file" .json)" \
        "python3 main_data.py $sim_config_file"

    # Alternatively, if you don't need separate tmux sessions, you can just run the Python script
    # python /path/to/main_data.py /path/to/sim_config_file"

    # Sleep if necessary to avoid overloading
    sleep 1
done

