import torch.nn as nn

class AdultPNN(nn.Module):
    def __init__(self, input_norm=None, **kwargs):
        super(AdultPNN, self).__init__()
        self.features = None
        self.classifier = nn.Sequential(nn.Linear(100, 32),
                                        nn.ReLU(),
                                        nn.Linear(32, 16),
                                        nn.ReLU(),
                                        nn.Linear(16, 2))
        self.norm = None

    def forward(self, x):
        x = x.view(x.size(0), -1)
        x = self.classifier(x)
        return x