import open3d as o3d
import subprocess
import numpy as np

executable = "bin/sample_points_on_unit_sphere"
output_npz_path = "views.npz"
num_samples = 8
radius = 1.1
command = [
    executable, "--output-npz-path", output_npz_path, "--num-samples",
    num_samples, "--radius", radius
]
command = [str(arg) for arg in command]
result = subprocess.run(command,
                        encoding="utf-8",
                        stdout=subprocess.PIPE,
                        stderr=subprocess.PIPE)
print(result.stdout)
print(result.stderr)

data = np.load(output_npz_path)
print(data.files)

views = data["views"]
print(views)
print(views.shape)

pcd = o3d.geometry.PointCloud()
pcd.points = o3d.utility.Vector3dVector(views)
print(pcd)
o3d.visualization.draw_geometries([pcd])