# Bayesian Meta-Learning for Few-Shot 3D Shape Completion

# ShapeNet

## Pre-processing the data

```
cd code/sdf-dataset-tools
git submodule update --init
mkdir build
cd build
cmake ..
make -j 8
export PANGOLIN_WINDOW_URI=headless://
```

```
cd bin
./sample_sdf --input-mesh-path /path/to/ShapeNet/ShapeNetCore/02958343/e06082fd22dbd3d425da9962b829b47/models/model_normalized.obj --output-npz-path /path/to/sdf/directory/02958343/e06082fd22dbd3d425da9962b829b47/sdf.npz
```

```
cd bin
./sample_surface_points --input-mesh-path /path/to/ShapeNet/ShapeNetCore/02958343/e06082fd22dbd3d425da9962b829b47/models/model_normalized.obj --output-npz-path /path/to/point_cloud/directory/02958343/e06082fd22dbd3d425da9962b829b47/point_cloud.npz
```

## Training

### DeepSDF

```
cd deep-sdf
python3 setup.py install --user
python3 scripts/training/shapenet/learning_shape_space.py  --dataset-directory /path/to/sdf/directory/ --train-split-path ../../splits/shapenet/shapenet_train.json
```

### IGR

```
cd implicit-geometric-regularization
python3 setup.py install --user
python3 scripts/training/shapenet/learning_shape_space.py  --dataset-directory /path/to/point_cloud/directory/ --train-split-path ../../splits/shapenet/shapenet_train.json
```

### PCN

```
cd point-completion-network
python3 setup.py install --user
python3 scripts/training/uniform_sparse_sampling.py  --dataset-directory /path/to/point_cloud/directory/ --train-split-path ../../splits/shapenet/shapenet_train.json
```

### OccNet

```
cd occupancy-networks
python3 setup.py install --user
python3 scripts/training/uniform_sparse_sampling/encoder.py --sdf-dataset-directory /path/to/sdf/directory/ --surface-dataset-directory /path/to/point_cloud/directory/ --split-path ../../splits/shapenet/shapenet_train.json
```

### Proposed Method

```
cd proposed_method
python3 setup.py install --user
python3 scripts/training/shapenet/uniform_sparse_sampling/baseline.py --dataset-directory /path/to/point_cloud/directory/ --split-path ../../splits/shapenet/shapenet_train.json
```

## Evaluation

### DeepSDF

```
cd deep-sdf
python3 setup.py install --user
python3 scripts/inference/shapenet/learning_shape_space/evaluation.py chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/  --output-directory evaluation/deep_sdf --pc-data-path /path/to/point_cloud/02958343/e06082fd22dbd3d425da9962b829b47/point_cloud.npz
```

### IGR

```
cd implicit-geometric-regularization
python3 setup.py install --user
python3 scripts/inference/shapenet/learning_shape_space/evaluation.py chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/igr --pc-data-path /path/to/point_cloud/02958343/e06082fd22dbd3d425da9962b829b47/point_cloud.npz
```

### PCN

```
cd point-completion-network
python3 setup.py install --user
python3 scripts/inference/uniform_sparse_sampling/evaluation.py chamfer_distance_surface_data  --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/pcn --npz-path /path/to/point_cloud/02958343/e06082fd22dbd3d425da9962b829b47/point_cloud.npz --chamfer-distance-method symmetric
```

### OccNet

```
cd occupancy-networks
python3 setup.py install --user
python3 scripts/inference/uniform_sparse_sampling/encoder/evaluation.py chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/occnet --npz-path /path/to/point_cloud/02958343/e06082fd22dbd3d425da9962b829b47/point_cloud.npz --chamfer-distance-method symmetric
```

### Proposed Method

```
cd proposed_method
python3 setup.py install --user
python3 scripts/inference/shapenet/uniform_sparse_sampling/baseline/evaluation.py  chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/proposed_method --pc-data-path /path/to/point_cloud/02958343/e06082fd22dbd3d425da9962b829b47/point_cloud.npz --chamfer-distance-method symmetric
```

# ICL-NUIM

## Pre-processing the data

```
cd proposed_method
python3 tools/icl_nuim/dataset.py convert_data_to_sdf_npz --depth-path /path/to/ICL-NUIM/living_room_traj2_frei_png/depth/592.png --output-path /path/to/sdf/directory/ICL-NUIM/traj1_frei_png/656.npz
```

```
cd proposed_method
python3 tools/icl_nuim/dataset.py convert_data_to_npz --depth-path /path/to/ICL-NUIM/living_room_traj2_frei_png/depth/592.png --output-path /path/to/point_cloud/directory/ICL-NUIM/traj1_frei_png/656.npz
```

## Training

### DeepSDF

```
cd deep-sdf
python3 setup.py install --user
python3 scripts/training/icl_nuim/learning_shape_space.py --dataset-directory /path/to/sdf/directory/ --train-split-path ../../splits/icl_nuim/icl_nuim_train.json
```

### IGR

```
cd implicit-geometric-regularization
python3 setup.py install --user
python3 scripts/training/icl_nuim/learning_shape_space.py  --dataset-directory /path/to/point_cloud/directory/ --train-split-path ../../splits/icl_nuim/icl_nuim_train.json
```

### PCN

```
cd point-completion-network
python3 setup.py install --user
python3 scripts/training/icl_nuim.py  --dataset-directory /path/to/point_cloud/directory/ --train-split-path ../../splits/icl_nuim/icl_nuim_train.json
```

### OccNet

```
cd occupancy-networks
python3 setup.py install --user
python3 scripts/training/icl_nuim/encoder.py --sdf-dataset-directory /path/to/sdf/directory/ --surface-dataset-directory /path/to/point_cloud/directory/ --split-path ../../splits/icl_nuim/icl_nuim_train.json
```

### Proposed Method

```
cd proposed_method
python3 setup.py install --user
python3 scripts/training/icl_nuim/uniform_sparse_sampling/baseline.py --dataset-directory /path/to/point_cloud/directory/ --split-path ../../splits/icl_nuim/icl_nuim_train.json
```

## Evaluation

### DeepSDF

```
cd deep-sdf
python3 setup.py install --user
python3 scripts/inference/icl_nuim/learning_shape_space/evaluation.py chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/  --output-directory evaluation/deep_sdf --pc-data-path /path/to/point_cloud/living_room_traj0_frei_png/depth/0.npz
```

### IGR

```
cd implicit-geometric-regularization
python3 setup.py install --user
python3 scripts/inference/icl_nuim/learning_shape_space/evaluation.py chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/igr --pc-data-path /path/to/point_cloud/living_room_traj0_frei_png/depth/0.npz
```

### PCN

```
cd point-completion-network
python3 setup.py install --user
python3 scripts/inference/icl_nuim/evaluation.py chamfer_distance_surface_data  --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/pcn --npz-path /path/to/point_cloud/living_room_traj0_frei_png/depth/0.npz --chamfer-distance-method symmetric
```

### OccNet

```
cd occupancy-networks
python3 setup.py install --user
python3 scripts/inference/icl_nuim/encoder/evaluation.py chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/occnet --npz-path /path/to/point_cloud/living_room_traj0_frei_png/depth/0.npz --chamfer-distance-method symmetric
```

### Proposed Method

```
cd proposed_method
python3 setup.py install --user
python3 scripts/inference/icl_nuim/uniform_sparse_sampling/baseline/evaluation.py  chamfer_distance_surface_data --checkpoint-directory /path/to/checkpoint/directory/ --output-directory evaluation/proposed_method --pc-data-path /path/to/point_cloud/living_room_traj0_frei_png/depth/0.npz --chamfer-distance-method symmetric
```
