import os
from pathlib import Path


def mkdir(directory):
    os.makedirs(directory, exist_ok=True)


def create_checkpoint_directory(args: object, run_id: str):
    try:
        if args.checkpoint_directory:
            return Path(args.checkpoint_directory)
    except ValueError:
        pass

    root = Path(args.checkpoint_directory_root
                ) if args.checkpoint_directory_root else Path(__file__).parent
    ret = root / "result_{}".format(run_id)
    mkdir(ret)
    return ret
