from dataclasses import dataclass

from meta_learning_sdf.classes import Hyperparameters


@dataclass
class ModelArgs(Hyperparameters):
    pass


@dataclass
class DeepSdfArgs(ModelArgs):
    checkpoint_directory: str = ""
    checkpoint_epoch: int = None
    latent_optimization_initial_lr: float = 0.005
    latent_optimization_iterations: int = 800
    prefix: str = "deepsdf"


@dataclass
class IgrArgs(ModelArgs):
    checkpoint_directory: str = ""
    checkpoint_epoch: int = None
    latent_optimization_initial_lr: float = 0.005
    latent_optimization_iterations: int = 800
    prefix: str = "igr"


@dataclass
class ProposedMethodArgs(ModelArgs):
    checkpoint_directory: str = ""
    checkpoint_epoch: int = None
    latent_optimization_initial_lr: float = 0.005
    latent_optimization_iterations: int = 800
    prefix: str = "proposed"


@dataclass
class PcnArgs(ModelArgs):
    checkpoint_directory: str = ""
    checkpoint_epoch: int = None
    prefix: str = "pcn"


@dataclass
class OccNetArgs(ModelArgs):
    checkpoint_directory: str = ""
    checkpoint_epoch: int = None
    prefix: str = "occnet"
