#include <cnpy.h>

#include <CLI/CLI.hpp>

#include "../functions.h"

void write_to_npz(std::vector<Eigen::Vector3f> &views, std::string path) {
    std::vector<float> data;
    for (auto &point : views) {
        data.push_back(point[0]);
        data.push_back(point[1]);
        data.push_back(point[2]);
    }
    cnpy::npz_save(path, "views", &data[0],
                   {(long unsigned int)(views.size()), 3}, "w");
}

int main(int argc, char **argv) {
    std::string npz_path;
    int num_sample = 100;
    float radius = 1;

    CLI::App app{"sample_points_on_unit_sphere"};
    app.add_option("--output-npz-path", npz_path)->required();
    app.add_option("--num-samples", num_sample);
    app.add_option("--radius", radius);
    CLI11_PARSE(app, argc, argv);

    std::vector<Eigen::Vector3f> views =
        sample_points_on_unit_sphere(num_sample, radius * 1.1);
    write_to_npz(views, npz_path);

    return 0;
}
