import argparse
import numpy as np
import open3d as o3d

parser = argparse.ArgumentParser()
parser.add_argument("--obj-path", type=str, required=True)
args = parser.parse_args()

mesh: o3d.geometry.TriangleMesh = o3d.io.read_triangle_mesh(args.obj_path)
print(mesh)
mesh.compute_triangle_normals()
mesh.compute_vertex_normals()
o3d.visualization.draw_geometries([mesh])