import argparse
import numpy as np
import open3d as o3d

parser = argparse.ArgumentParser()
parser.add_argument("--npz-path", type=str, required=True)
args = parser.parse_args()

data = np.load(args.npz_path)
points = data["vertices"]
normals = data["vertex_normals"]
print(points.shape)
print(normals.shape)

# ind = np.where((-0.6 < points[:, 2]) * (points[:, 2] < -0.4))[0]
# points = points[ind]
# normals = normals[ind]

pcd = o3d.geometry.PointCloud()
pcd.points = o3d.utility.Vector3dVector(points)
pcd.normals = o3d.utility.Vector3dVector(normals)
o3d.visualization.draw_geometries([pcd])