import torch.nn as nn
import torch

class SimpleMLP(nn.Module):
    def __init__(self, hidden_dim):
        super(SimpleMLP, self).__init__()
        self.mlp = nn.Sequential(
            nn.Linear(hidden_dim, hidden_dim),
            nn.ReLU()
        )
        self.fc = nn.Linear(hidden_dim, hidden_dim)

    def forward(self, x):
        x = self.mlp(x)
        x = self.fc(x)
        return x

