    import json

    # Paths to your files
    first_json_path = "/home/user/llava/LLaVA/POPE/output/coco/coco_pope_random.json"
    second_json_path = "/home/user/llava/LLaVA/POPE/segmentation/coco_ground_truth_segmentation.json"
    output_path = "./src/cal_set/coco_segmentation_filtered.json"

    # Load all images used in the first JSON
    used_images = set()
    with open(first_json_path, "r") as f:
        for line in f:
            data = json.loads(line)
            used_images.add(data["image"])

    # Load and filter the second JSON
    filtered_data = []
    with open(second_json_path, "r") as f:
        for line in f:
            data = json.loads(line)
            if data["image"] not in used_images:
                filtered_data.append(data)

    # Save the filtered results
    with open(output_path, "w") as f:
        for item in filtered_data:
            f.write(json.dumps(item) + "\n")

    print(f"Filtered {len(filtered_data)} entries saved to: {output_path}")