This repository contains the implementation of all experiments presented in our paper on GRAPHHASH.

---

## 🔧 Requirements

We use recent versions of the following libraries:

- `pytorch`
- `numpy`
- `scipy`
- `sklearn`
- `networkx`
- `omegaconf`
- `seaborn`
- `matplotlib`

To install all dependencies, run:

```bash
conda create --name <env> --file requirements.txt
```

---

## 📂 Datasets

- Subgraph Matching datasets: `./data/`
- GED datasets (unequal cost): `./uneq_ged_data/`
- GED datasets (equal cost): `./ged_data/`

Please download the dataset archive from [https://rebrand.ly/ghash](https://rebrand.ly/ghash) and replace the dummy folders. This package includes the original graphs, dataset splits, and all intermediate dumps required to reproduce our experiments and plots.

---

## 📁 Code Organization

###  Core LSH Implementations (`./lsh`)
- `ghash2_trained.py`: GRAPHHASH
- `fhash_trained.py`: FourierHashNet
- `rh_trained.py`: Random Hyperplane (RH)
- `diskann.py`: DISKANN interface
- `faiss.py`: FAISS IVF interface
- `train_ghash_fmaps.py`: Fourier map training for GRAPHHASH
- `train_fmaps.py`: Fourier map training for FourierHashNet
- `train_hashcode.py`: Train hashcodes for RH

###  Dataset and Evaluation Scripts (`./src`)
- `graph_data_generator.py`: Generate Subgraph Matching data and labels
- `graph_ged_data_generator.py`: Generate equal-cost GED dataset and labels
- `graph_ged_unequal_cost_gt_generator.py`: Load GED dataset and compute variable-cost ground truth
- `exchbl_expt.py`: Run exchangeability validation experiments
- `perf_plots.py`: Generate performance plots (MAP, NDCG, etc.)
- `models.py`: GNN architectures for GEN and ISONET
- `train_scalable.py`: Train GEN or ISONET encoders

---

##  Reproducing Experiments

###  Dataset Sampling
- Located in: `scripts/graph_dataset_sampling/`

###  Embedding Model Training
- Scripts for GEN and ISONET: `scripts/embedding_training/`

###  LSH Training
- Fourier map and hashcode training: `scripts/lsh_training/`

### Hashing and Retrieval
- Run experiments: `scripts/hashing/`

### Exchangeability Evaluation
- Plot and analysis scripts: `scripts/exchbl/`

---

## ⚠️ Notes

- All LSH methods require GPU support for training and evaluation.
