#!/bin/bash

datasets=('ptc_fr' 'cox2')
# rel_modes=('sub_iso' 'ged')
rel_modes=('sub_iso' 'ged' 'uneq_ged')

freegpus=(0 1 2 3 4)
ctr=0

for dataset in "${datasets[@]}"; do
    for rel_mode in "${rel_modes[@]}"; do
        
        CUDA_VISIBLE_DEVICES=${freegpus[$((ctr % ${#freegpus[@]}))]} \
        python3 -m src.exchbl_expt dataset.name="$dataset" dataset.rel_mode="$rel_mode" \
                expt.train=False expt.plot3=True expt.plot4=False model.name=NANL &

        ctr=$((ctr + 1))

        
    done
    wait
done

