#!/bin/bash

datasets=('cox2' 'ptc_fr')
rel_modes=('sub_iso' 'ged')
# freegpus=(0 1 2 3 4 5 6)
freegpus=(4 5)
ctr=0
for dataset in "${datasets[@]}"; do
    for rel_mode in "${rel_modes[@]}"; do
        CUDA_VISIBLE_DEVICES=${freegpus[$((ctr % ${#freegpus[@]}))]} \
        python3 -m src.distn_expt dataset.name="$dataset" dataset.rel_mode="$rel_mode" model.name=NANL train=False &

        ctr=$((ctr + 1))
    done
done
wait