import json
import pandas as pd

df = pd.read_csv('image_data.csv') 
with open('error_prompts.json', 'r') as f:
    error_prompts = json.load(f)
unsure_prompts = []
for prompt in error_prompts['other_error_prompts']:
    unsure_prompts.append(prompt['prompt'])
    
df_1 = df[df['harmful_original_task'].isin(error_prompts['policy_violation_prompts'])]
df_1.to_csv('all_policy_violation_prompts.csv', index=False)

df_2 = df[df['harmful_original_task'].isin(unsure_prompts)]
df_2.to_csv('all_unsure_prompts.csv', index=False)