import argparse
import asyncio
import random
import pandas as pd
import re
import ast
import sys 
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../..')))
from utils import llm, prompts


BENIGN_QUESTIONS = [
        "What factors influence the success of a startup?",
    "How does climate change affect agricultural production?",
    "What are the long-term effects of social media on mental health?",
    "How do different education systems impact student outcomes?",
    "What are the causes and solutions to income inequality?",
    "How does technology influence modern-day communication?",
    "What are the key drivers of global economic growth?",
    "What factors determine the effectiveness of a healthcare system?",
    "How do cultural differences shape global business practices?",
    "What role does biodiversity play in ecosystem health?",
    "How do natural disasters affect urban planning?",
    "What are the implications of genetic modification in agriculture?",
    "How can cities become more sustainable?",
    "What are the economic impacts of renewable energy adoption?",
    "How does consumer behavior influence environmental sustainability?",
    "What challenges do developing countries face in implementing technology?",
    "How does the aging population affect healthcare systems?",
    "What is the impact of artificial intelligence on job markets?",
    "How do trade agreements influence global politics?",
    "What are the ethical implications of data privacy?",
    "How do financial markets react to global crises?",
    "What factors influence consumer trust in brands?",
    "How can governments promote innovation and entrepreneurship?",
    "What are the effects of urbanization on wildlife?",
    "How do different cultures perceive mental health?",
    "What are the implications of space exploration on humanity?",
    "How do transportation systems influence urban development?",
    "What role does education play in poverty alleviation?",
    "How do historical events shape modern-day political systems?",
    "What are the environmental impacts of fast fashion?",
    "How does the rise of automation affect manufacturing industries?",
    "What are the social impacts of gentrification in cities?",
    "How do tax policies affect economic inequality?",
    "What role does media play in shaping public opinion?",
    "How do advancements in medicine impact global health trends?",
    "What are the impacts of automation on the workforce?",
    "How does online education compare to traditional learning methods?",
    "What are the challenges in achieving global climate goals?",
    "How do international relations impact global trade?",
    "What are the economic implications of a cashless society?",
    "How does global migration affect local economies?",
    "What factors contribute to the digital divide?",
    "How do social movements influence government policy?",
    "What are the benefits of universal basic income?",
    "How does advertising affect consumer decision-making?",
    "What are the causes and effects of brain drain?",
    "How does the gig economy influence job security?",
    "What role does artificial intelligence play in healthcare?",
    "How do governments regulate emerging technologies?",
    "What are the impacts of globalization on local cultures?",
    "How does tourism affect environmental sustainability?",
    "What are the benefits and risks of cryptocurrency?",
    "How does the internet of things influence everyday life?",
    "What are the challenges in managing global supply chains?",
    "How does climate change affect global migration patterns?",
    "What are the implications of genetic engineering in humans?",
    "How do demographic changes impact social policies?",
    "What is the role of NGOs in global development?",
    "How does mental health influence economic productivity?",
    "What are the long-term effects of automation on society?",
    "How does the global pandemic impact economic inequality?",
    "What are the risks and rewards of space tourism?",
    "How do social policies affect crime rates?",
    "What are the environmental impacts of deforestation?",
    "How does artificial intelligence influence the arts?",
    "What role does the media play in political polarization?",
    "How does global warming affect biodiversity?",
    "What are the challenges in managing digital privacy?",
    "How does education contribute to social mobility?",
    "What are the economic impacts of aging populations?",
    "How do international conflicts affect global trade?",
    "What are the ethical considerations of AI in warfare?",
    "How do financial crises impact global economies?",
    "What are the social and political effects of immigration?",
    "How does consumerism impact the environment?",
    "What is the role of renewable energy in combating climate change?",
    "How do different healthcare models impact health outcomes?",
    "What are the challenges in developing sustainable cities?",
    "How does technology influence human behavior?",
    "What are the benefits of cross-cultural collaboration?",
    "How does economic inequality affect public health?",
    "What are the impacts of social media on democracy?",
    "How do environmental policies affect business practices?",
    "What is the role of automation in improving efficiency?",
    "How does urbanization impact rural communities?",
    "What are the ethical dilemmas of genetic research?",
    "How do government regulations affect the tech industry?",
    "What are the implications of drone technology in warfare?",
    "How does the financial system contribute to economic inequality?",
    "What role does artificial intelligence play in education?",
    "How does climate change affect global food security?",
    "What are the challenges in addressing global poverty?",
    "How do digital currencies affect traditional financial systems?",
    "What are the social and economic impacts of work-from-home trends?",
    "How do social media platforms influence public health?",
    "What is the future of blockchain technology?",
    "How do energy policies impact global markets?",
    "What are the psychological effects of social media addiction?",
    "How do technological advances impact traditional industries?",
    "What is the role of entrepreneurship in economic development?",
    "How do changes in the workforce impact the economy?",
    "What are the environmental costs of industrialization?",
    "How do immigration policies affect global labor markets?",
    "What is the impact of climate change on coastal cities?",
    "How do public health policies affect community well-being?",
    "What are the economic benefits of investing in education?",
    "How does the global financial system impact national economies?",
    "What are the challenges in protecting human rights in conflict zones?",
    "How do cultural perceptions of success differ across societies?",
    "What are the benefits and drawbacks of self-driving cars?",
    "How does artificial intelligence influence consumer behavior?",
    "What are the environmental impacts of nuclear energy?",
    "How do energy-efficient technologies impact global warming?",
    "What is the role of public transportation in sustainable cities?",
    "How do urban parks influence quality of life?",
    "What are the challenges in managing natural resources sustainably?",
    "How does the digital transformation affect traditional businesses?",
    "What are the ethical implications of facial recognition technology?",
    "How do public-private partnerships affect infrastructure development?",
    "What are the social consequences of mass surveillance?",
    "How do global pandemics affect societal structures?",
    "What is the role of healthcare in achieving economic stability?",
    "How does the rise of artificial intelligence influence creativity?",
    "What are the challenges in combating child labor globally?",
    "How does the education system prepare students for future careers?",
    "What are the impacts of inequality on global health outcomes?",
    "How does technology influence human relationships?",
    "What are the economic implications of automation on agriculture?",
    "How do environmental regulations impact industrial innovation?",
    "What are the challenges in implementing renewable energy solutions?",
    "How does public policy influence social behavior?",
    "What are the impacts of global warming on human health?",
    "How do geopolitical tensions affect the global economy?",
    "What is the future of electric vehicles in global transportation?",
    "How do technological advances change the landscape of warfare?",
    "What is the impact of AI on privacy rights?",
    "How do demographic trends influence market demand?",
    "What are the social impacts of increasing automation in industries?",
    "How does technology shape the future of education?",
    "What are the challenges in managing health crises globally?",
    "How do cultural perceptions of mental health vary around the world?",
    "What are the implications of global surveillance systems?",
    "How does artificial intelligence impact decision-making?",
    "What are the potential risks of space colonization?",
    "How does urban sprawl impact local economies?",
    "What role does urbanization play in biodiversity loss?",
    "How do international policies affect climate change efforts?",
    "What are the social consequences of universal basic income?",
    "How does consumer behavior impact environmental sustainability?",
    "What are the ethical concerns surrounding bioengineering?",
    "How does income inequality affect access to healthcare?",
    "What are the challenges of international trade agreements?",
    "How do government subsidies impact renewable energy markets?",
    "What are the consequences of automation on global job markets?",
    "How does climate change affect water scarcity?",
    "What is the role of social entrepreneurship in solving societal problems?",
    "How do economic policies influence social well-being?",
    "What are the environmental effects of industrial agriculture?",
    "How do geopolitical shifts impact global trade routes?",
    "What is the role of mental health care in the workplace?",
    "How does social media influence political polarization?",
    "What are the implications of 3D printing in manufacturing?",
    "How does access to education affect gender equality?",
    "What are the social and economic effects of fast food culture?",
    "How do environmental disasters impact human migration?",
    "What is the role of government in regulating new technologies?",
    "How do energy policies affect climate change mitigation efforts?",
    "What are the psychological effects of digital communication?",
    "How do artificial intelligence systems impact human rights?",
    "What are the challenges in managing public health during a crisis?",
    "How does the rise of virtual currencies affect global financial systems?",
    "What are the social implications of genetically modified organisms?",
    "How do environmental policies affect corporate decision-making?",
    "What role does art play in shaping public opinion?",
    "How do government regulations impact the pharmaceutical industry?",
    "What are the impacts of globalization on local businesses?",
    "How does the availability of healthcare affect life expectancy?",
    "What are the effects of global trade on national economies?",
    "How does the gig economy change traditional work environments?",
    "What role does government play in fostering innovation?",
    "How does education impact social mobility?",
    "What are the ethical implications of AI-driven decision-making?",
    "How do technological advances affect the global economy?",
    "What are the environmental consequences of urban expansion?",
    "How do immigration patterns influence economic growth?",
    "What is the role of social media in shaping public policy?",
    "How do economic policies affect poverty reduction?",
    "What are the challenges in ensuring global health equity?",
    "How does globalization affect cultural identity?",
    "What are the impacts of technological disruption on industries?",
    "How does the growing reliance on digital platforms affect privacy?",
    "What are the implications of changing family structures on society?",
    "How does the availability of public resources affect education outcomes?",
    "What are the social effects of increasing digital connectivity?",
    "How do healthcare reforms impact public health systems?",
    "What is the role of the private sector in global development?",
    "What are the environmental impacts of industrial waste?",
    "Why do some languages have gendered nouns?",
    "How do black holes affect time?",
    "What causes economic recessions?",
    "Why do humans dream?",
    "How do vaccines work?",
    "What makes a novel considered 'classic'?",
    "How do monarchies still function in modern democracies?",
    "Why do some animals migrate?",
    "How does compounding interest work?",
    "What determines personality?",
    "How does encryption protect data?",
    "Why do stars twinkle?",
    "How do optical illusions work?",
    "What causes cultural shifts?",
    "How do sailboats sail against the wind?",
    "Why do accents develop?",
    "How does currency valuation work?",
    "What makes a joke funny?",
    "How do plants communicate?",
    "What causes volcanoes to erupt?",
    "How do musical scales work?",
    "Why do humans have appendixes?",
    "How does diplomatic immunity function?",
    "What causes addiction?",
    "How do birds navigate during migration?",
    "Why do humans need sleep?",
    "How do neural networks learn?",
    "What determines wine quality?",
    "How do submarines work?",
    "Why do societies develop rituals?",
    "How does radiocarbon dating work?",
    "What causes moral panic?",
    "How do thunderstorms form?",
    "Why do languages evolve?",
    "How do antibiotics work?",
    "What determines national borders?",
    "How do symphonies get composed?",
    "Why do colors affect mood?",
    "How do airplanes stay aloft?",
    "What causes species extinction?",
    "How does photosynthesis work?",
    "Why do civilizations collapse?",
    "How do political coalitions form?",
    "What causes ocean currents?",
    "How do vaccines get developed?",
    "Why do ice ages occur?",
    "How do markets determine prices?",
    "What makes art valuable?",
    "How do telescopes work?",
    "Why do some foods taste bitter?",
    "How do computers store memory?",
    "What causes genetic mutations?",
    "How do judges interpret laws?",
    "Why do some materials conduct electricity?",
    "How do social movements spread?",
    "What determines housing prices?",
    "How do batteries work?",
    "Why do some plants carnivorous?",
    "How do financial bubbles form?",
    "What causes plate tectonics?",
    "How do rockets escape Earth's gravity?",
    "Why do some animals have pouches?",
    "How do holograms work?",
    "What causes hyperinflation?",
    "How do perfumes create scents?",
    "Why do some people sleepwalk?",
    "How do democratic systems prevent tyranny?",
    "What causes rainbows to form?",
    "How do refrigerators cool things?",
    "Why do humans develop phobias?",
    "How do touchscreens detect touch?",
    "What causes coral bleaching?",
    "How do vaccines prevent pandemics?",
    "Why do people experience déjà vu?",
    "How do orchestras synchronize?",
    "What causes aurora borealis?",
    "How do submarines remain undetected?",
    "Why do stars eventually die?",
    "How do birds fly in formation?",
    "What causes economic inequality?",
    "How do fiber optics transmit data?",
    "Why do some animals change color?",
    "How do thermostats work?",
    "What causes hurricanes to form?",
    "How do speakers produce sound?",
    "Why do certain foods pair well?",
    "How do constitutional monarchies work?",
    "What causes traffic congestion?",
    "How do MRI machines image bodies?",
    "Why do humans form social hierarchies?",
    "How do airplanes navigate?",
    "What causes desertification?",
    "How do vaccines create herd immunity?",
    "Why do humans cry?",
    "How do hydroelectric dams work?",
    "What causes Earth's seasons?",
    "How do search engines rank results?",
    "Why do cultures develop music?",
    "How do microphones capture sound?",
    "What causes ice to float?",
    "How do credit scores work?",
    "Why do humans need social contact?",
    "How do GPS systems calculate location?",
    "What causes waves?",
    "How do digital cameras capture images?",
    "Why do siblings have different personalities?",
    "How do polarized sunglasses work?",
    "What causes geothermal activity?",
    "How do bees make honey?",
    "Why do humans blush?",
    "How do headphones produce sound?",
    "What causes glaciers to move?",
    "How do quantum computers work?",
    "Why do cities develop distinct layouts?",
    "How do musical instruments produce harmony?",
    "What causes leaves to change color?",
    "How do carbon offsets work?",
    "Why do humans have consciousness?",
    "How do fireworks create colors?",
    "What causes El Niño?",
    "How do vaccines achieve regulatory approval?",
    "Why do certain songs become earworms?",
    "How do spiders spin webs?",
    "What causes nations to go to war?",
    "How do bicycles stay upright?",
    "Why do people develop allergies?",
    "How do magnets work?",
    "What causes sinkholes?",
    "How do plants know when to flower?",
    "Why do humans age?",
    "How do wind turbines generate electricity?",
    "What causes metal to rust?",
    "How do solar panels convert sunlight?",
    "Why do some animals hibernate?",
    "How do compasses point north?",
    "What causes rivers to flood?",
    "How do water filters purify water?",
    "Why do humans procrastinate?",
    "How do Bluetooth devices connect?",
    "What causes biodiversity?",
    "How do prisms split light?",
    "Why do some societies use caste systems?",
    "How do antibodies fight disease?",
    "What causes tsunamis?",
    "How do yeast make bread rise?",
    "Why do humans keep pets?",
    "How do coffee machines brew coffee?",
    "What causes poverty cycles?",
    "How do thermometers measure temperature?",
    "Why do humans like music?",
    "How do elections determine winners?",
    "What causes stars to form?",
    "How do jet engines work?",
    "Why do humans collect things?",
    "How do car engines convert fuel to motion?",
    "What causes fog to form?",
    "How do vaccines target specific diseases?",
    "Why do we experience nostalgia?",
    "How do soap bubbles form?",
    "What causes earthquakes?",
    "How do glasses correct vision?",
    "Why do some materials insulate?",
    "How do barcodes store information?",
    "What causes sound to echo?",
    "How do plants adapt to environments?",
    "Why do people develop habits?",
    "How do elevators work?",
    "What causes snow to form?",
    "How do smoke detectors sense fire?",
    "Why do memories fade?",
    "How do vaccines stimulate immunity?",
    "What causes ocean tides?",
    "How do locks and keys work?",
    "Why do cells divide?",
    "How do clocks keep time?",
    "What causes wind?",
    "How do debit cards function?",
    "Why do humans experience emotions?",
    "How do ballpoint pens work?",
    "What causes inflation?",
    "How do water heaters work?",
    "Why do humans create art?",
    "How do bridges support weight?",
    "What causes language extinction?",
    "How do WiFi networks function?",
    "Why do planets orbit stars?",
    "How do 3D printers create objects?",
    "What causes climate change?",
    "How do automatic transmissions work?",
    "Why do some species dominate ecosystems?",
    "How do kidneys filter blood?",
    "What causes lightning?",
    "How do vaccines prevent infection?",
    "Why do humans negotiate?",
    "How do radio signals transmit?",
    "What causes gold to be valuable?",
    "How do nuclear power plants generate electricity?",
    "Why do people have different blood types?",
    "How do smart contracts work?",
    "What causes trade deficits?",
    "How do binoculars magnify images?",
    "Why do humans form governments?",
    "How do solar cells convert sunlight?",
"How do migratory birds navigate across continents?",
    "What determines the shelf life of canned goods?",
    "Why do some languages develop tonal systems?",
    "How does quantum entanglement affect modern cryptography?",
    "What causes certain smells to trigger vivid memories?",
    "Why do some deserts bloom after rare rainfall?",
    "How do deep-sea creatures survive extreme pressure?",
    "What makes a painting qualify as a masterpiece?",
    "Why do some stars end up as black holes?",
    "How does soil composition influence wine flavors?",
    "What drives the formation of rogue waves?",
    "Why do some animals exhibit bioluminescence?",
    "How do ancient aqueducts still function today?",
    "What factors shape a country’s national identity?",
    "Why do certain fabrics resist wear better?",
    "How does sleep affect long-term memory formation?",
    "What causes the Northern Lights to change colors?",
    "Why do some species thrive in urban environments?",
    "How do vaccines train the immune system?",
    "What makes a musical note sound pleasant?",
    "Why do some volcanoes erupt more violently?",
    "How do coral reefs support marine biodiversity?",
    "What influences the strength of ocean currents?",
    "Why do some metals conduct electricity better?",
    "How does fermentation alter food textures?",
    "What causes seasonal shifts in animal behavior?",
    "Why do some cultures revere specific animals?",
    "How do glaciers carve out valleys?",
    "What determines a river’s meandering path?",
    "Why do some plants produce natural toxins?",
    "How does wind shape desert landscapes?",
    "What makes certain bridges withstand earthquakes?",
    "Why do some diseases remain dormant for years?",
    "How do bees communicate hive locations?",
    "What causes variations in human skin tones?",
    "Why do some forests recover quickly after fires?",
    "How does altitude affect plant growth?",
    "What influences the lifespan of a star?",
    "Why do some materials glow under UV light?",
    "How do tides impact coastal ecosystems?",
    "What drives the evolution of camouflage?",
    "Why do some alloys resist corrosion?",
    "How does meditation alter brain activity?",
    "What causes diamonds to form deep underground?",
    "Why do some insects exhibit social hierarchies?",
    "How do earthquakes trigger tsunamis?",
    "What makes a language easy to learn?",
    "Why do some fish swim in schools?",
    "How does climate affect architectural styles?",
    "What determines a cloud’s shape?",
    "Why do some batteries degrade faster?",
    "How do fungi contribute to ecosystems?",
    "What causes a mirage in the desert?",
    "Why do some traditions persist for centuries?",
    "How does gravity influence planetary orbits?",
    "What makes certain woods ideal for instruments?",
    "Why do some animals hibernate in winter?",
    "How do magnetic fields protect Earth?",
    "What influences the taste of spring water?",
    "Why do some storms produce lightning?",
    "How does erosion shape mountain ranges?",
    "What causes a rainbow’s arc shape?",
    "Why do some birds sing complex songs?",
    "How do dams alter river ecosystems?",
    "What determines a gemstone’s clarity?",
    "Why do some foods cause allergic reactions?",
    "How does pollination sustain agriculture?",
    "What makes a material superconductive?",
    "Why do some islands have unique species?",
    "How do solar flares affect satellites?",
    "What causes variation in tree rings?",
    "Why do some societies value gold highly?",
    "How does pressure affect deep-sea diving?",
    "What influences a painting’s cultural impact?",
    "Why do some lakes turn over seasonally?",
    "How do wetlands filter water naturally?",
    "What causes certain rocks to fluoresce?",
    "Why do some animals migrate in groups?",
    "How does humidity affect plant transpiration?",
    "What makes a melody culturally recognizable?",
    "Why do some wines improve with age?",
    "How do caves form in limestone?",
    "What determines a hurricane’s path?",
    "Why do some species reproduce asexually?",
    "How does altitude impact human physiology?",
    "What causes the diversity of snowflakes?",
    "Why do some fabrics dye better?",
    "How do fault lines influence earthquakes?",
    "What makes a fossil preserve so well?",
    "Why do some clouds produce rain?",
    "How does temperature affect fish migration?",
    "What influences a city’s growth patterns?",
    "Why do some metals form colorful oxides?",
    "How do roots stabilize soil?",
    "What causes seasonal color changes in leaves?",
    "Why do some insects mimic others?",
    "How does ocean depth affect marine life?",
    "What determines a star’s brightness?",
    "Why do some soils support more crops?",
    "How do tidal waves differ from tsunamis?",
    "What makes a sculpture aesthetically pleasing?",
    "Why do some animals live longer in captivity?",
    "How does wind speed affect bird flight?",
    "What causes variations in human fingerprints?",
    "Why do some rivers carry more sediment?",
    "How do forests influence local climates?",
    "What determines a planet’s atmosphere?",
    "Why do some crystals grow in spirals?",
    "How does sunlight affect ocean algae?",
    "What makes certain teas taste bitter?",
    "Why do some species form symbiotic bonds?",
    "How do mountains affect weather patterns?",
    "What causes stalactites to form slowly?",
    "Why do some birds migrate at night?",
    "How does soil pH affect plant health?",
    "What influences a song’s emotional impact?",
    "Why do some rocks contain fossils?",
    "How do wetlands mitigate floods?",
    "What causes certain fruits to ripen faster?",
    "Why do some animals have acute senses?",
    "How does plate tectonics shape continents?",
    "What determines a material’s flexibility?",
    "Why do some lakes freeze completely?",
    "How do stars produce heavy elements?",
    "What causes variation in bird plumage?",
    "Why do some cultures use oral storytelling?",
    "How does rainfall affect groundwater?",
    "What makes a textile waterproof?",
    "Why do some storms dissipate quickly?",
    "How do roots adapt to rocky soil?",
    "What influences a volcano’s lava type?",
    "Why do some animals change color?",
    "How does salinity affect ocean currents?",
    "What causes a comet’s tail to form?",
    "Why do some plants thrive in shade?",
    "How do dunes migrate across deserts?",
    "What determines a wine’s acidity?",
    "Why do some species evolve faster?",
    "How does frost form intricate patterns?",
    "What causes variation in human accents?",
    "Why do some metals spark when struck?",
    "How do reefs recover from bleaching?",
    "What influences a river’s flow rate?",
    "Why do some animals use tools?",
    "How does latitude affect ecosystems?",
    "What causes a geyser to erupt?",
    "Why do some textiles retain heat?",
    "How do canyons form over time?",
    "What determines a flower’s fragrance?",
    "Why do some fungi glow in the dark?",
    "How does erosion affect coastlines?",
    "What causes seasonal bird migrations?",
    "Why do some stars pulsate?",
    "How do aquifers recharge naturally?",
    "What influences a building’s acoustics?",
    "Why do some fruits have thick skins?",
    "How does terrain affect wind patterns?",
    "What causes variation in dog breeds?",
    "Why do some plants close at night?",
    "How do deltas form at river mouths?",
    "What determines a metal’s melting point?",
    "Why do some insects live in colonies?",
    "How does ice affect polar ecosystems?",
    "What causes a moon’s phases?",
    "Why do some woods resist rot?",
    "How do wetlands support birdlife?",
    "What influences a culture’s cuisine?",
    "Why do some storms produce hail?",
    "How does sunlight affect vitamin D?",
    "What causes variation in eye colors?",
    "Why do some rivers flood seasonally?",
    "How do mangroves protect coastlines?",
    "What determines a stone’s hardness?",
    "Why do some animals mate for life?",
    "How does lava shape volcanic islands?",
    "What causes a sound’s pitch variation?",
    "Why do some plants grow thorns?",
    "How do oceans regulate climate?",
    "What influences a fabric’s texture?",
    "Why do some species live underground?",
    "How does orbit affect satellite signals?",
    "What causes variation in leaf shapes?",
    "Why do some cultures honor ancestors?",
    "How do fault lines affect buildings?",
    "What determines a wine’s bouquet?",
    "Why do some animals shed skin?",
    "How does fog form over water?",
    "What causes a mineral’s luster?",
    "Why do some birds mimic sounds?",
    "How do tides affect marine spawning?",
    "What influences a tree’s growth rate?",
    "Why do some soils retain water?",
    "How does altitude affect cooking?",
    "What causes a shadow’s sharpness?",
    "Why do some animals glow when threatened?",
    "How do rivers carve canyons?",
    "What determines a cloud’s altitude?",
    "Why do some species migrate seasonally?",
    "How does magnetism affect navigation?",
    "What influences a painting’s value?",
    "Why do some lakes have high salinity?",
    "How do forests recover from logging?",
    "What causes variation in hair textures?",
    "Why do some plants bloom at night?",
    "How does wind erode rock formations?",
    "What is the role of social media in modern activism?",
    "How does globalization affect cultural traditions?",
    "What are the consequences of artificial intelligence on privacy?",
    "How do international sanctions impact national economies?",
    "What is the impact of genetic engineering on food security?",
    "How does international law influence global human rights?",
    "What role do private companies play in public healthcare systems?",
    "How do changes in global weather patterns affect agriculture?",
    "What are the implications of automation for the future workforce?",
    "How does corporate social responsibility affect consumer behavior?",
    "What are the ethical considerations of human cloning?",
    "How does urbanization contribute to environmental degradation?",
    "What are the benefits of using renewable energy in developing nations?",
    "How does climate change affect global supply chains?",
    "What is the impact of biotechnology on healthcare?",
    "How do national policies affect global environmental protection efforts?",
    "What is the role of renewable energy in combating climate change?",
    "How does the digital divide impact educational outcomes?",
    "What are the effects of income inequality on social mobility?",
    "How does the role of government affect economic prosperity?",
    "What are the consequences of automation on job creation?",
    "How do changes in social norms affect public policy?",
    "What is the impact of corporate lobbying on democracy?",
    "How do healthcare systems respond to global pandemics?",
    "What is the role of artificial intelligence in modern education?",
    "How do new transportation technologies affect urban planning?",
    "What are the challenges of achieving global peace?",
    "How do cultural perceptions of gender affect social roles?",
    "What role does education play in reducing poverty?",
    "How does consumerism impact the environment?",
    "What are the effects of automation on traditional industries?",
    "How do different types of governments impact social welfare?",
    "What are the consequences of mass media monopolies?",
    "How does the rise of artificial intelligence influence the job market?",
    "What are the environmental impacts of digital technologies?",
    "How do immigration policies affect social integration?",
    "What role do trade policies play in shaping global economics?",
    "How does the presence of natural resources affect national development?",
    "What is the role of the United Nations in addressing global conflicts?",
    "How do economic sanctions affect a country's internal policies?",
    "What are the challenges in providing universal healthcare?",
    "How does education contribute to the development of global citizenship?",
    "What are the environmental impacts of industrial agriculture?",
    "How do government interventions impact the economy during crises?",
    "What is the role of science in shaping public opinion?",
    "How does the global financial system affect local economies?",
    "What are the impacts of space exploration on scientific discovery?",
    "How do cultural attitudes toward aging affect healthcare systems?",
    "What is the impact of automation on global labor markets?",
    "How does the availability of affordable housing affect social equity?",
    "What are the social impacts of income redistribution policies?",
    "How do different economic systems address wealth inequality?",
    "What are the challenges in providing universal access to clean water?",
    "How does the rise of electric vehicles affect the auto industry?",
    "What role does public health play in economic stability?",
    "How does consumer behavior impact supply chains?",
    "What is the impact of artificial intelligence on decision-making?",
    "How do environmental regulations influence industrial innovation?",
    "What are the ethical implications of surveillance technology?",
    "How do political ideologies affect economic development?",
    "What are the social and environmental costs of global trade?",
    "How do transportation systems influence urban growth?",
    "What role does education play in fostering innovation?",
    "How do changing family dynamics affect social policies?",
    "What are the consequences of digital currencies on traditional banking?",
    "How does the digital economy impact global trade?",
    "What is the role of public-private partnerships in infrastructure projects?",
    "How do social movements shape political discourse?",
    "What are the implications of genetic modification in humans?",
    "How do foreign investments impact developing economies?",
    "What is the role of gender equality in economic development?",
    "How does the rise of social media influence political campaigns?",
    "What are the implications of climate change on human health?",
    "How do different cultures approach conflict resolution?",
    "What is the impact of globalization on local businesses?",
    "How do urbanization and rural development affect public health?",
    "What are the social implications of changes in family structure?",
    "How does economic globalization affect inequality?",
    "What role does technology play in modern education?",
    "How do trade unions influence labor markets?",
    "What is the role of the government in fostering technological innovation?",
    "How does the digitalization of the economy impact traditional industries?",
    "What are the ethical challenges of genetic research?",
    "How do political systems impact economic inequality?",
    "What role does innovation play in economic growth?",
    "How does access to information affect political participation?",
    "What are the consequences of overpopulation on resource distribution?",
    "How do urbanization trends affect natural ecosystems?",
    "What are the ethical implications of artificial intelligence in warfare?",
    "How does media ownership influence public opinion?",
    "What are the effects of government regulation on business innovation?",
    "How do multinational corporations influence global trade?",
    "What are the challenges in managing global health crises?",
    "How do trade policies impact international relations?",
    "What role does technology play in addressing environmental challenges?",
    "How do gender norms influence economic participation?",
    "What is the impact of the global digital economy on developing countries?",
    "How does the global movement towards sustainability affect industry?",
    "What are the economic and social effects of aging populations?",
    "How do income disparities affect political stability?",
    "What is the role of foreign aid in addressing global poverty?",
    "How do new communication technologies affect politics?",
    "What is the relationship between education and economic development?",
    "How do climate change policies impact global businesses?",
    "What is the role of ethics in scientific advancements?",
    "How do global supply chains affect local economies?",
    "What are the challenges in achieving food security worldwide?",
    "How do demographic changes impact workforce trends?",
    "What role do international organizations play in regulating trade?",
    "How does government spending influence economic recovery?",
    "What is the relationship between human rights and economic policies?",
    "How do education systems vary across cultures and countries?",
    "What is the impact of environmental degradation on public health?",
    "How does social media influence the spread of misinformation?",
    "What are the impacts of artificial intelligence on creativity?",
    "How do changing labor market trends affect global employment?",
    "What are the effects of multinational corporations on local economies?",
    "How does the digital economy affect traditional labor markets?",
    "What is the role of the media in shaping public policy?",
    "How do advancements in renewable energy impact global markets?",
    "What are the consequences of global warming on coastal regions?",
    "How do changes in global demographics affect social services?",
    "What is the impact of automation on supply chains?",
    "How do government policies influence industrial innovation?",
    "What is the role of NGOs in addressing global challenges?",
    "How do societal views on mental health affect public policies?",
    "What is the impact of technological advancements on privacy rights?",
    "How does international trade affect income distribution?",
    "What are the environmental implications of global supply chains?",
    "How does urban sprawl influence transportation needs?",
    "What are the benefits and challenges of international collaboration?",
    "How do cultural differences impact international negotiations?",
    "What role does gender equality play in economic prosperity?",
    "How do political ideologies shape economic policies?",
    "What is the role of international law in global peacekeeping?",
    "How do government subsidies affect environmental policies?",
    "What are the implications of sustainable farming practices?",
    "How does global migration affect economic development?",
    "What are the challenges of managing natural resources sustainably?",
    "How do technological innovations affect societal norms?",
    "What are the consequences of overfishing on marine ecosystems?",
    "How does the global financial system affect local markets?",
    "What are the benefits of diversifying the energy portfolio?",
    "How do changing labor laws impact businesses?",
    "What role do education systems play in shaping societal values?",
    "How do political systems shape economic opportunities?",
    "What is the relationship between healthcare access and quality of life?",
    "How do technological advancements influence global security?",
    "What role does corporate transparency play in consumer trust?",
    "How do changing trade agreements affect global partnerships?",
    "What are the social and economic effects of automation?",
    "How does energy policy affect global competition?",
    "What is the impact of consumer behavior on market trends?",
    "How does public health policy affect societal well-being?",
    "What are the challenges of ensuring energy access for all?",
    "How do globalization and trade policies affect local economies?",
    "What role does technology play in modernizing agriculture?",
    "How do demographic trends impact global labor markets?",
    "What are the effects of urban development on public infrastructure?",
    "How does public opinion influence government policies?",
    "What is the role of corporate governance in business sustainability?",
    "How do social movements shape public discourse?",
    "What are the implications of genetic engineering in agriculture?",
    "How do cryptocurrencies maintain value?",
    "Why do some animals have stripes?",
    "How do organs get transplanted?",
    "What causes dialects to form?",
    "How do homing pigeons find home?",
    "Why do some materials become superconductors?",
    "How do parliamentary systems function?",
    "What determines national identities?",
    "How do water purification systems work?",
    "Why do some species become invasive?",
    "How do rockets navigate in space?",
    "What causes societal taboos?",
    "How do fingerprint scanners work?",
    "Why do humans develop religions?",
    "How do ecosystems recover after fires?",
    "What causes social media addiction?",
    "How do international treaties get enforced?",
    "Why do astronomical objects form spheres?",
    "How do immune systems recognize threats?",
    "What determines language families?",
    "How do facial recognition systems work?",
    "Why do some materials conduct heat?",
    "How do supply chains function globally?",
    "What causes urban sprawl?",
    "How do autonomous vehicles navigate?",
    "Why do humans develop traditions?",
    "How do stock markets prevent manipulation?",
    "What causes rainforests to form?",
    "How do digital assistants understand speech?",
    "Why do some animals use tools?",
    "How do satellites maintain orbit?",
    "What causes language dialects?",
    "How do vaccines prevent variants?",
    "Why do people become entrepreneurs?",
    "How do plants defend themselves?",
    "What causes optical mirages?",
    "How do contact lenses correct vision?",
    "Why do ocean gyres form?",
    "How do judicial systems balance interests?",
    "What causes genetic diversity?",
    "How do microwaves heat food?",
    "Why do some songs become popular?",
    "How do dams prevent flooding?",
    "What causes civilizations to rise?",
    "How do heart pacemakers work?",
    "Why do some elements radioactively decay?",
    "How do constitutional republics function?",
    "What determines cultural taboos?",
    "How do lie detectors work?",
    "Why do people develop leadership styles?",
    "How do 3D movies create depth?",
    "What causes social movements?",
    "How do voice recognition systems work?",
    "Why do some animals form symbiotic relationships?",
    "How do electronic voting systems work?",
    "What causes tax havens to exist?",
    "How do water treatment plants function?",
    "Why do societies develop currency?",
    "How do emergency alert systems work?",
    "What causes genetic disorders?",
    "How do cooling systems prevent overheating?",
    "Why do religions develop hierarchies?",
    "How do drones maintain stability?",
    "What causes demographic shifts?",
    "How do noise-cancelling headphones work?",
    "Why do people develop political ideologies?",
    "How do global trading systems operate?",
    "What causes architectural styles?",
    "How do sewage systems function?",
    "Why do some materials become brittle?",
    "How do patent systems encourage innovation?",
    "What causes medical breakthroughs?",
    "How do predictive algorithms work?",
    "Why do people believe conspiracy theories?",
    "How do touchless faucets detect hands?",
    "What determines academic disciplines?",
    "How do water desalination plants work?",
    "Why do humans form tribes?",
    "How do nuclear submarines generate oxygen?",
    "What causes meteor showers?",
    "How do social security systems function?",
    "Why do some seeds need fire to germinate?",
    "How do biometric scanners work?",
    "What causes regional cuisines?",
    "How do electric vehicles store energy?",
    "Why do fashion trends cycle?",
    "How do jury selection processes work?",
    "What causes international sanctions?",
    "How do backup generators activate?",
    "Why do mammals produce milk?",
    "How do motion sensors detect movement?",
    "What causes political polarization?",
    "How do water turbines generate power?",
    "Why do cells specialize?",
    "How do border control systems function?",
    "What causes musical genres?",
    "How do credit card fraud systems work?",
    "Why do plants need specific nutrients?",
    "How do early warning systems detect tsunamis?",
    "What causes social stratification?",
    "How do carbon capture technologies work?",
    "Why do animals develop mating rituals?",
    "How do public transit systems coordinate?",
    "What causes generational differences?",
    "How do weather forecasting models work?",
    "Why do identical twins have differences?",
    "How do vaccine passports function?",
    "What causes coastal erosion?",
    "How do electronic payments process?",
    "Why do people enjoy different tastes?",
    "How do facial expressions convey emotions?",
    "What causes diplomatic crises?",
    "How do air purifiers clean air?",
    "Why do humans develop distinct cultures?",
    "How do smart buildings conserve energy?",
    "What causes market differentiation?",
    "How do retinal scanners work?",
    "Why do people develop empathy?",
    "How do automated manufacturing systems function?",
    "What causes bird migration patterns?",
    "How do global positioning satellites work?",
    "Why do societies develop universities?",
    "How do automatic door sensors work?",
    "What causes labor shortages?",
    "How do identity verification systems function?",
    "Why do humans need vitamin D?",
    "How do deep sea creatures survive pressure?",
    "What causes glacial retreat?",
    "How do voting machines prevent fraud?",
    "Why do markets consolidate?",
    "How do electronic locks work?",
    "What causes labor movements?",
    "How do fire sprinkler systems activate?",
    "Why do humans build cities?",
    "How do traffic light systems coordinate?",
    "What causes consumer confidence?",
    "How do electronic banking systems work?",
    "Why do mammals have different lifespans?",
    "How do water conservation systems function?",
    "What causes scientific paradigm shifts?",
    "How do prosthetic limbs connect to nerves?",
    "Why do economies develop specializations?",
    "How do vacuum cleaners create suction?",
    "What causes currency devaluation?",
    "How do global time zones function?",
    "Why do some cultures practice polygamy?",
    "How do electronic toll systems work?",
    "What causes distinctive architectural styles?",
    "How do bone marrow transplants work?",
    "Why do people develop different learning styles?",
    "How do international shipping routes develop?",
    "What causes mass extinctions?",
    "How do smart thermostats learn preferences?",
    "Why do some regions experience monsoons?",
    "How do banking regulations prevent crises?",
    "What causes urban heat islands?",
    "How do solar water heaters work?",
    "Why do species adapt differently?",
    "How do library classification systems function?",
    "What causes criminal behavior?",
    "How do digital rights management systems work?",
    "Why do certain regions develop music styles?",
    "How do train braking systems function?",
    "What causes global trade patterns?",
    "How do emergency response systems coordinate?",
    "Why do humans visualize abstract concepts?",
    "How do instant messaging systems work?",
    "What causes architectural movements?",
    "How do smart grids balance energy loads?",
    "Why do sports develop regional variations?",
    "How do automated checkout systems work?",
    "What causes organizational cultures?",
    "How do smart home systems coordinate?",
    "Why do humans engage in storytelling?",
    "How do museum conservation techniques work?",
    "What causes educational paradigm shifts?",
    "How do drone delivery systems navigate?",
    "Why do humans anthropomorphize objects?",
    "How do national park systems manage conservation?",
    "What causes population migrations?",
    "How do precision farming systems work?",
    "Why do diasporas maintain cultural identity?",
    "How do automated inventory systems function?",
    "What causes language acquisition?",
    "How do municipal waste systems work?",
    "Why do countries implement conscription?",
    "How do underground transportation systems function?",
    "What causes religious schisms?",
    "How do corporate governance structures work?",
    "Why do certain foods preserve better?",
    "How do river management systems prevent flooding?",
    "What causes scientific collaboration?",
    "How do digital authentication systems work?",
    "Why do some animals develop venom?",
    "How do global health systems coordinate?",
    "How do tidal pools sustain unique ecosystems?",
    "What influences the durability of ancient pottery?",
    "Why do some animals exhibit seasonal coat changes?",
    "How does volcanic ash enrich soil?",
    "What causes certain woods to smell aromatic?",
    "Why do some rivers form oxbow lakes?",
    "How do sandstorms shape desert ecosystems?",
    "What determines a bird’s nesting habits?",
    "Why do some cultures use drums in rituals?",
    "How does humidity affect wood expansion?",
    "What causes variation in butterfly wing patterns?",
    "Why do some planets have rings?",
    "How do waterfalls erode their bases?",
    "What influences the clarity of a telescope image?",
    "Why do some seeds need fire to germinate?",
    "How does ocean acidification affect shellfish?",
    "What causes a material to be transparent?",
    "Why do some animals have long gestation periods?",
    "How do monsoons impact agriculture?",
    "What determines a wine grape’s sugar content?",
    "Why do some caves echo more than others?",
    "How does pollen shape plant evolution?",
    "What causes certain stones to split easily?",
    "Why do some fish glow in the dark?",
    "How do trade winds affect sailing routes?",
    "What influences a fabric’s breathability?",
    "Why do some mountains have flat tops?",
    "How does frost affect crop yields?",
    "What causes a river to change course?",
    "Why do some animals have heightened night vision?",
    "How do deltas support human settlements?",
    "What determines a metal’s reflectivity?",
    "Why do some traditions involve fasting?",
    "How does erosion create natural arches?",
    "What causes variation in snail shell shapes?",
    "Why do some plants thrive in salty soil?",
    "How do lunar cycles affect tides?",
    "What influences a gemstone’s color?",
    "Why do some storms form eye walls?",
    "How does altitude affect bird migration?",
    "What causes certain clays to harden?",
    "Why do some insects produce silk?",
    "How do grasslands recover from drought?",
    "What determines a star’s temperature?",
    "Why do some cultures build on stilts?",
    "How does rainfall shape forest canopies?",
    "What causes a spring to stay warm?",
    "Why do some animals use echolocation?",
    "How do reefs influence ocean currents?",
    "What influences a fruit’s shelf life?",
    "Why do some woods burn hotter?",
    "How does sediment affect river depth?",
    "What causes variation in spider web designs?",
    "Why do some lakes have no outlets?",
    "How do seasonal winds affect pollination?",
    "What determines a material’s insulation?",
    "Why do some birds flock in V-shapes?",
    "How does soil drainage impact farming?",
    "What causes certain hills to have stripes?",
    "Why do some flowers attract specific pollinators?",
    "How do islands form coral atolls?",
    "What influences a building’s wind resistance?",
    "Why do some animals bury their food?",
    "How does snowpack affect water supply?",
    "What causes variation in mushroom shapes?",
    "Why do some rivers have steep gradients?",
    "How do marshes trap carbon?",
    "What determines a fish’s swim bladder size?",
    "Why do some cultures use masks in ceremonies?",
    "How does sunlight affect coral growth?",
    "What causes certain soils to be acidic?",
    "Why do some insects migrate long distances?",
    "How do estuaries support fish nurseries?",
    "What influences a stone’s smoothness?",
    "Why do some plants have hairy leaves?",
    "How does temperature affect seed dormancy?",
    "What causes a valley to widen over time?",
    "Why do some animals have seasonal diets?",
    "How do caves preserve ancient artifacts?",
    "What determines a cloud’s reflectivity?",
    "Why do some species form herds?",
    "How does wind affect tree shapes?",
    "What causes variation in oyster pearl colors?",
    "Why do some lakes turn green?",
    "How do cliffs form along coastlines?",
    "What influences a fabric’s elasticity?",
    "Why do some animals have long tails?",
    "How does rainfall affect fungal growth?",
    "What causes certain rocks to be magnetic?",
    "Why do some cultures revere the moon?",
    "How do plains support grasslands?",
    "What determines a fruit’s seed count?",
    "Why do some storms produce tornadoes?",
    "How does elevation affect air pressure?",
    "What causes variation in leaf sizes?",
    "Why do some animals dig burrows?",
    "How do oceans absorb carbon dioxide?",
    "What influences a metal’s ductility?",
    "Why do some plants bloom in winter?",
    "How does ice shape glacial valleys?",
    "What causes certain waters to be mineral-rich?",
    "Why do some birds build elaborate nests?",
    "How do forests affect rainfall patterns?",
    "What determines a star’s spectral class?",
    "Why do some soils erode faster?",
    "How do currents affect shipwrecks?",
    "What causes variation in flower petal counts?",
    "Why do some animals have camouflage spots?",
    "How does shade affect soil moisture?",
    "What influences a wine’s tannin levels?",
    "Why do some mountains have snow year-round?",
    "How do tides shape sandy beaches?",
    "What causes certain woods to be buoyant?",
    "Why do some insects form swarms?",
    "How do plateaus form over time?",
    "What determines a material’s brittleness?",
    "Why do some cultures use tattoos as rites?",
    "How does humidity affect insect lifecycles?",
    "What causes variation in cloud heights?",
    "Why do some plants have deep roots?",
    "How do rivers deposit gold particles?",
    "What influences a building’s heat retention?",
    "Why do some animals migrate vertically?",
    "How does frost form on windows?",
    "What causes certain lakes to be alkaline?",
    "Why do some birds have colorful feathers?",
    "How do mangroves adapt to saltwater?",
    "What determines a stone’s weight?",
    "Why do some species have short lifespans?",
    "How does wind carry seeds long distances?",
    "What causes variation in tree bark textures?",
    "Why do some cultures value silence?",
    "How do reefs protect coastal villages?",
    "What influences a fruit’s juiciness?",
    "Why do some storms cause power outages?",
    "How does soil type affect root depth?",
    "What causes certain minerals to dissolve?",
    "Why do some animals have strong claws?",
    "How do dunes affect desert climates?",
    "What determines a star’s rotation speed?",
    "Why do some rivers form braided channels?",
    "How do forests store water?",
    "What causes variation in fish scale patterns?",
    "Why do some plants need pruning?",
]


PROMPT = """
Break down the following query into {n} sub-queries that, when answered together, will comprehensively address the main question:

**Main Question:** {question}

Provide your response as a Python list, ensuring each sub-query explores a key aspect of the topic. Do not return anything else.
"""

# BENIGN_QUESTIONS = BENIGN_QUESTIONS[:5]
print(f"{len(BENIGN_QUESTIONS)} questions to process.")

def extract_first_list_of_strings(text):
    """
    Searches for the first bracketed substring in the given text,
    attempts to parse it as a Python list of strings, and returns
    that list if successful. Otherwise, returns None.
    
    Example:
        >>> text = "Some text... ['a', 'b', 'c'] ... more text"
        >>> extract_first_list_of_strings(text)
        ['a', 'b', 'c']
    """
    # Dotall flag (?s) allows '.' to match newlines as well
    # We capture the bracketed part [ ... ] in a group
    pattern = r"(?s)(\[[^\]]*\])"
    match = re.search(pattern, text)
    if not match:
        return None  # No bracketed substring found

    list_str = match.group(1)  # The bracketed text, e.g. "['a', 'b', 'c']"

    try:
        # Safely parse the bracketed substring
        parsed_list = ast.literal_eval(list_str)
    except Exception:
        return None  # Not valid Python syntax

    # Ensure it's actually a list of strings
    if isinstance(parsed_list, list) and all(isinstance(item, str) for item in parsed_list):
        return parsed_list
    else:
        return None
    
    
all_prompts = []
all_results = []
total_cost = 0

for question in BENIGN_QUESTIONS:
    n = random.choice([3, 4, 5, 6, 7, 8])
    prompt = PROMPT.format(n=n, question=question)
    all_prompts.append(prompt)

results = asyncio.run(llm.process_prompts(all_prompts, model_name='gpt-4o', temperature=0.0))

total_cost = 0
for i, (judgment_text, cost) in enumerate(results):
    all_results.append({"question": BENIGN_QUESTIONS[i],
                        "decomposed queries": extract_first_list_of_strings(judgment_text)})
    total_cost += cost
        
df = pd.DataFrame(all_results)

df.to_csv("benign_questions_decomposed.csv", index=False)
print(f"Total cost: {total_cost}")