import matplotlib.pyplot as plt
import numpy as np

import pdb

def parse_file(file_name):
    task = {}
    try:
        with open(file_name,'r') as f:
            for i,line in enumerate(f):
                if i==7: # full task
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    for j in range(len(line)):
                        task['{}%'.format(j*20)] = [line[j]]
                  
                elif i ==9:  # std_f1
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(line[j])
                
                elif i ==12: # view_score
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                  
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(abs(line[j]))
                elif i ==17: # nesum in featre
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(abs(line[j]))
                elif i ==27: # reconstruction
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(abs(line[j]))
                elif i == 32: # nesum in dnn
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(abs(line[j]))
                elif i == 47: # noise score
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(abs(line[j]))
                elif i == 42: # denoise
                    line = line.strip().split(',')
                    line = [float(x) for x in line]
                    for j in range(len(line)):
                        task['{}%'.format(j*20)].append(abs(line[j]))
                  
                else:
                    continue
        return True,task
    except:
        return False,None






# get list

methods = ['linear_cca','linear_gcca','dcca','dgcca']


dataset = ['PolyMnist_2','PolyMnist_3','PolyMnist_4','PolyMnist_5','CUB_2_0','Caltech101_3_0'] # 25 150
#dataset = ['PolyMnist_2','PolyMnist_3','CUB_2_0','Caltech101_3_0']

epochs = [100,200,300,400,500]
num_views =[2]


pdf_data = {}
#method_data = {}
plt.style.use('seaborn-poster')

for data in dataset:
    for method in methods:
        t_methods = [method]
        if 'cca' in method and 'd' in method:
            t_methods.append(method+'e')
            t_methods.append(method+'_with_noise')
            t_methods.append(method+'_private')
           
        t_epochs = epochs
        for method in t_methods:
            for epoch in t_epochs:
                data_name,num_view = data.split('_')[0], data.split('_')[1]
               
                if data_name=='PolyMnist':
                    file_name = "./Polymnist_output/{}_{}_{}_{}.csv".format(method,True,num_view,epoch)
                else:
                    file_name = "./CPM_OUTPUT_NEW/{}_{}_{}_{}_{}.csv".format(data,method,True,num_view,epoch)
               
                flag,task = parse_file(file_name)
                    #pdb.set_trace()
                # if method == 'dcca_dis':
                #     pdb.set_trace()
                
                if not  flag:
                    print('no',file_name)
                        #pdb.set_trace()
                    continue
                    
                try:
                    for task_name in task:
                            
                        print(data)
                        if data not in pdf_data:
                            pdf_data[data] = {}
                            #pdb.set_trace()
                        if epoch not in pdf_data[data]:
                            pdf_data[data][epoch] ={}
                            #pdb.set_trace()
                        if method not in pdf_data[data][epoch]:
                            pdf_data[data][epoch][method] = {}
                            #pdb.set_trace()
                        pdf_data[data][epoch][method][task_name] = task[task_name]
                except Exception as e:
                    print(e)
                    pdb.set_trace()
                    continue
#pdb.set_trace()
#lists = {'list1': 'red', 'list2': 'blue', 'list3': 'green', 'list4': 'purple', 'list5': 'orange', 'list6': 'black'}
colors = ['red','blue','green','purple','orange','black','brown','gold','grey']
marker = ['o','s','^','v','<','>','x','+']

fig, axes = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_1, axes_1 = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_s = [fig,fig_1]

axes_s = [axes,axes_1]

methods_s = [['linear_cca','dcca'],['linear_gcca','dgcca']]

for f,methods in enumerate(methods_s):
    for k in range(len(dataset)):
        data = dataset[k]
        data_name,num_view = data.split('_')[0], data.split('_')[1]
        for i,method in enumerate(methods):
            t_methods = [method]
            if 'cca' in method and 'd' in method:
                t_methods.append(method+'e')
                
                t_methods.append(method+'_private')
                t_methods.append(method+'_with_noise')
            #pdb.set_trace()
            for j,method in enumerate(t_methods):
                if method in ['kcca']:
                    continue
            #pdb.set_trace()
                y_mean = []
                
                for epoch in epochs:
                    #pdb.set_trace()
                    if method not in pdf_data[data][epoch]:

                        try:
                            y_mean.append(pdf_data[data][epochs[0]][method]['0%'][0])
                        except:
                            y_mean.append(pdf_data[data][epochs[-1]][method]['0%'][0])
                    else:
                        y_mean.append(pdf_data[data][epoch][method]['0%'][0])
                    
                    #y_mean.append(pdf_data[epochs[0]][method][common][3])
                x = np.array(epochs)
                y_mean = np.array(y_mean) 
                #pdb.set_trace()
                method = method.upper()
                if ('CCA' in method and 'D' in method) or method=='LINEAR_CCA'  or method=='LINEAR_GCCA':
                    if method=='dcca_with_noise'.upper():
                        method='NR-dcca'.upper()+'(ours)'
                    if method=='dgcca_with_noise'.upper():
                        method='NR-dgcca'.upper()  +'(ours)'
                    
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[f+1])
                    #print(method,i,j)
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std , label=method, color=colors[i+j],marker=marker[f+1])
                elif method=='mvtcae'.upper():
                    #pdb.set_trace()
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+4],marker=marker[0])
                else:
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std,label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                #axes[f][k].fill_between(x, y_mean-y_std, y_mean+y_std, color=colors[i+j], alpha=0.1)
        #if f==0:
        axes_s[f][k].set_title('{}'.format(data_name+'({})'.format(num_view)))
        if k==0:
            axes_s[f][k].legend()
        axes_s[f][k].grid(linestyle= ':',linewidth=1)
       

axes_s[0][0].set_ylabel('F1_score',fontsize=24)
axes_s[1][0].set_ylabel('F1_score',fontsize=24)

fig_s[0].text(0.5, -0.05, 'Epoch', fontsize=24)
fig_s[1].text(0.5, -0.05, 'Epoch', fontsize=24)
#ylabel.set_position((0.5, -0.1))
plt.xticks(epochs,epochs)
fig_s[0].tight_layout()
fig_s[1].tight_layout()

fig_s[0].savefig('./draw_pictures/Real_F1_CCA.png', dpi=300, bbox_inches='tight')
fig_s[1].savefig('./draw_pictures/Real_F1_GCCA.png', dpi=300, bbox_inches='tight')
    
   
plt.close()


fig, axes = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_1, axes_1 = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_s = [fig,fig_1]

axes_s = [axes,axes_1]

methods_s = [['linear_cca','dcca'],['linear_gcca','dgcca']]

for f,methods in enumerate(methods_s):
    for k in range(len(dataset)):
        data = dataset[k]
        data_name,num_view = data.split('_')[0], data.split('_')[1]
        for i,method in enumerate(methods):
            t_methods = [method]
            if 'cca' in method and 'd' in method:
                t_methods.append(method+'e')
                
                t_methods.append(method+'_private')
                t_methods.append(method+'_with_noise')
            #pdb.set_trace()
            for j,method in enumerate(t_methods):
                if method in ['kcca']:
                    continue
            #pdb.set_trace()
                y_mean = []
                
                for epoch in epochs:
                    #pdb.set_trace()
                    if method not in pdf_data[data][epoch]:
                        import pdb
                        print(method)
                        pdb.set_trace()
                        try:
                            y_mean.append(pdf_data[data][epochs[0]][method]['0%'][3])
                        except:
                            y_mean.append(pdf_data[data][epochs[-1]][method]['0%'][3])
                    else:
                        import pdb
                        #print(method)
                        #pdb.set_trace()
                        try:
                            y_mean.append(pdf_data[data][epoch][method]['0%'][3])
                        except:
                            print(method)
                            pdb.set_trace()
                    #y_mean.append(pdf_data[epochs[0]][method][common][3])
                x = np.array(epochs)
                y_mean = np.array(y_mean) 
                #pdb.set_trace()
                method = method.upper()
                if ('CCA' in method and 'D' in method) or method=='LINEAR_CCA'  or method=='LINEAR_GCCA':
                    if method=='dcca_with_noise'.upper():
                        method='NR-dcca'.upper()+'(ours)'
                    if method=='dgcca_with_noise'.upper():
                        method='NR-dgcca'.upper()  +'(ours)'
                    
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[f+1])
                    #print(method,i,j)
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std , label=method, color=colors[i+j],marker=marker[f+1])
                elif method=='mvtcae'.upper():
                    #pdb.set_trace()
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+4],marker=marker[0])
                else:
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std,label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                #axes[f][k].fill_between(x, y_mean-y_std, y_mean+y_std, color=colors[i+j], alpha=0.1)
        #if f==0:
        axes_s[f][k].set_title('{}'.format(data_name+'({})'.format(num_view)))
        if k==0:
            axes_s[f][k].legend()
        axes_s[f][k].grid(linestyle= ':',linewidth=1)
       

axes_s[0][0].set_ylabel('Nesum_in_feature',fontsize=24)
axes_s[1][0].set_ylabel('Nesum_in_feature',fontsize=24)

fig_s[0].text(0.5, -0.05, 'Epoch', fontsize=24)
fig_s[1].text(0.5, -0.05, 'Epoch', fontsize=24)
#ylabel.set_position((0.5, -0.1))
plt.xticks(epochs,epochs)
fig_s[0].tight_layout()
fig_s[1].tight_layout()

fig_s[0].savefig('./draw_pictures/Real_Nesum_in_feature_CCA.png', dpi=300, bbox_inches='tight')
fig_s[1].savefig('./draw_pictures/Real_Nesum_in_feature_GCCA.png', dpi=300, bbox_inches='tight')
    
   
plt.close()




fig, axes = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_1, axes_1 = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_s = [fig,fig_1]

axes_s = [axes,axes_1]

methods_s = [['linear_cca','dcca'],['linear_gcca','dgcca']]

for f,methods in enumerate(methods_s):
    for k in range(len(dataset)):
        data = dataset[k]
        data_name,num_view = data.split('_')[0], data.split('_')[1]
        for i,method in enumerate(methods):
            t_methods = [method]
            if 'cca' in method and 'd' in method:
                t_methods.append(method+'e')
                
                t_methods.append(method+'_private')
                t_methods.append(method+'_with_noise')
            #pdb.set_trace()
            for j,method in enumerate(t_methods):
                if method in ['kcca']:
                    continue
            #pdb.set_trace()
                y_mean = []
                
                for epoch in epochs:
                    #pdb.set_trace()
                    if method not in pdf_data[data][epoch]:

                        try:
                            y_mean.append(pdf_data[data][epochs[0]][method]['0%'][4])
                        except:
                            y_mean.append(pdf_data[data][epochs[-1]][method]['0%'][4])
                    else:
                        y_mean.append(pdf_data[data][epoch][method]['0%'][4])
                    
                    #y_mean.append(pdf_data[epochs[0]][method][common][3])
                x = np.array(epochs)
                y_mean = np.array(y_mean) 
                #pdb.set_trace()
                method = method.upper()
                if ('CCA' in method and 'D' in method) or method=='LINEAR_CCA'  or method=='LINEAR_GCCA':
                    if method=='dcca_with_noise'.upper():
                        method='NR-dcca'.upper()+'(ours)'
                    if method=='dgcca_with_noise'.upper():
                        method='NR-dgcca'.upper()  +'(ours)'
                    
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[f+1])
                    #print(method,i,j)
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std , label=method, color=colors[i+j],marker=marker[f+1])
                elif method=='mvtcae'.upper():
                    #pdb.set_trace()
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+4],marker=marker[0])
                else:
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std,label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                #axes[f][k].fill_between(x, y_mean-y_std, y_mean+y_std, color=colors[i+j], alpha=0.1)
        #if f==0:
        axes_s[f][k].set_title('{}'.format(data_name+'({})'.format(num_view)))
        if k==0:
            axes_s[f][k].legend()
        axes_s[f][k].grid(linestyle= ':',linewidth=1)
       

axes_s[0][0].set_ylabel('Reconstrution Loss',fontsize=24)
axes_s[1][0].set_ylabel('Reconstrution Loss',fontsize=24)

fig_s[0].text(0.5, -0.05, 'Epoch', fontsize=24)
fig_s[1].text(0.5, -0.05, 'Epoch', fontsize=24)
#ylabel.set_position((0.5, -0.1))
plt.xticks(epochs,epochs)
fig_s[0].tight_layout()
fig_s[1].tight_layout()

fig_s[0].savefig('./draw_pictures/Real_Reconstrution_CCA.png', dpi=300, bbox_inches='tight')
fig_s[1].savefig('./draw_pictures/Real_Reconstrution_GCCA.png', dpi=300, bbox_inches='tight')
    
   
plt.close()


fig, axes = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_1, axes_1 = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_s = [fig,fig_1]

axes_s = [axes,axes_1]

methods_s = [['linear_cca','dcca'],['linear_gcca','dgcca']]

for f,methods in enumerate(methods_s):
    for k in range(len(dataset)):
        data = dataset[k]
        data_name,num_view = data.split('_')[0], data.split('_')[1]
        for i,method in enumerate(methods):
            t_methods = [method]
            if 'cca' in method and 'd' in method:
                t_methods.append(method+'e')
                
                t_methods.append(method+'_private')
                t_methods.append(method+'_with_noise')
            #pdb.set_trace()
            for j,method in enumerate(t_methods):
                if method in ['kcca']:
                    continue
            #pdb.set_trace()
                y_mean = []
                
                for epoch in epochs:
                    #pdb.set_trace()
                    if method not in pdf_data[data][epoch]:

                        try:
                            y_mean.append(pdf_data[data][epochs[0]][method]['0%'][5])
                        except:
                            y_mean.append(pdf_data[data][epochs[-1]][method]['0%'][5])
                    else:
                        y_mean.append(pdf_data[data][epoch][method]['0%'][5])
                    
                    #y_mean.append(pdf_data[epochs[0]][method][common][3])
                x = np.array(epochs)
                y_mean = np.array(y_mean) 
                #pdb.set_trace()
                method = method.upper()
                if ('CCA' in method and 'D' in method) or method=='LINEAR_CCA'  or method=='LINEAR_GCCA':
                    if method=='dcca_with_noise'.upper():
                        method='NR-dcca'.upper()+'(ours)'
                    if method=='dgcca_with_noise'.upper():
                        method='NR-dgcca'.upper()  +'(ours)'
                    
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[f+1])
                    #print(method,i,j)
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std , label=method, color=colors[i+j],marker=marker[f+1])
                elif method=='mvtcae'.upper():
                    #pdb.set_trace()
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+4],marker=marker[0])
                else:
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std,label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                #axes[f][k].fill_between(x, y_mean-y_std, y_mean+y_std, color=colors[i+j], alpha=0.1)
        #if f==0:
        axes_s[f][k].set_title('{}'.format(data_name+'({})'.format(num_view)))
        if k==0:
            axes_s[f][k].legend()
        axes_s[f][k].grid(linestyle= ':',linewidth=1)
       

axes_s[0][0].set_ylabel('Nesum_dnn',fontsize=24)
axes_s[1][0].set_ylabel('Nesum_dnn',fontsize=24)

fig_s[0].text(0.5, -0.05, 'Epoch', fontsize=24)
fig_s[1].text(0.5, -0.05, 'Epoch', fontsize=24)
#ylabel.set_position((0.5, -0.1))
plt.xticks(epochs,epochs)
fig_s[0].tight_layout()
fig_s[1].tight_layout()

fig_s[0].savefig('./draw_pictures/Real_Nesum_dnn_CCA.png', dpi=300, bbox_inches='tight')
fig_s[1].savefig('./draw_pictures/Real_Nesum_dnn_GCCA.png', dpi=300, bbox_inches='tight')
    
   
plt.close()

fig, axes = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_1, axes_1 = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_s = [fig,fig_1]

axes_s = [axes,axes_1]

methods_s = [['linear_cca','dcca'],['linear_gcca','dgcca']]

for f,methods in enumerate(methods_s):
    for k in range(len(dataset)):
        data = dataset[k]
        data_name,num_view = data.split('_')[0], data.split('_')[1]
        for i,method in enumerate(methods):
            t_methods = [method]
            if 'cca' in method and 'd' in method:
                t_methods.append(method+'e')
                
                t_methods.append(method+'_private')
                t_methods.append(method+'_with_noise')
            #pdb.set_trace()
            for j,method in enumerate(t_methods):
                if method in ['kcca']:
                    continue
            #pdb.set_trace()
                y_mean = []
                
                for epoch in epochs:
                    #pdb.set_trace()
                    if method not in pdf_data[data][epoch]:

                        try:
                            y_mean.append(pdf_data[data][epochs[0]][method]['0%'][7])
                        except:
                            y_mean.append(pdf_data[data][epochs[-1]][method]['0%'][7])
                    else:
                        y_mean.append(pdf_data[data][epoch][method]['0%'][7])
                    
                    #y_mean.append(pdf_data[epochs[0]][method][common][3])
                x = np.array(epochs)
                y_mean = np.array(y_mean) 
                #pdb.set_trace()
                method = method.upper()
                if ('CCA' in method and 'D' in method) or method=='LINEAR_CCA'  or method=='LINEAR_GCCA':
                    if method=='dcca_with_noise'.upper():
                        method='NR-dcca'.upper()+'(ours)'
                    if method=='dgcca_with_noise'.upper():
                        method='NR-dgcca'.upper()  +'(ours)'
                    
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[f+1])
                    #print(method,i,j)
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std , label=method, color=colors[i+j],marker=marker[f+1])
                elif method=='mvtcae'.upper():
                    #pdb.set_trace()
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+4],marker=marker[0])
                else:
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std,label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                #axes[f][k].fill_between(x, y_mean-y_std, y_mean+y_std, color=colors[i+j], alpha=0.1)
        #if f==0:
        axes_s[f][k].set_title('{}'.format(data_name+'({})'.format(num_view)))
        if k==0:
            axes_s[f][k].legend()
        axes_s[f][k].grid(linestyle= ':',linewidth=1)
       

axes_s[0][0].set_ylabel('Noise_cor',fontsize=24)
axes_s[1][0].set_ylabel('Noise_cor',fontsize=24)

fig_s[0].text(0.5, -0.05, 'Epoch', fontsize=24)
fig_s[1].text(0.5, -0.05, 'Epoch', fontsize=24)
#ylabel.set_position((0.5, -0.1))
plt.xticks(epochs,epochs)
fig_s[0].tight_layout()
fig_s[1].tight_layout()

fig_s[0].savefig('./draw_pictures/Real_Noise_score_CCA.png', dpi=300, bbox_inches='tight')
fig_s[1].savefig('./draw_pictures/Real_Noise_score_GCCA.png', dpi=300, bbox_inches='tight')
    
   
plt.close()

fig, axes = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_1, axes_1 = plt.subplots(1, len(dataset),figsize=(35, 6),sharex=True, sharey='col')

fig_s = [fig,fig_1]

axes_s = [axes,axes_1]

methods_s = [['linear_cca','dcca'],['linear_gcca','dgcca']]

for f,methods in enumerate(methods_s):
    for k in range(len(dataset)):
        data = dataset[k]
        data_name,num_view = data.split('_')[0], data.split('_')[1]
        for i,method in enumerate(methods):
            t_methods = [method]
            if 'cca' in method and 'd' in method:
                t_methods.append(method+'e')
                
                t_methods.append(method+'_private')
                t_methods.append(method+'_with_noise')
            #pdb.set_trace()
            for j,method in enumerate(t_methods):
                if method in ['kcca']:
                    continue
            #pdb.set_trace()
                y_mean = []
                
                for epoch in epochs:
                    #pdb.set_trace()
                    if method not in pdf_data[data][epoch]:

                        try:
                            y_mean.append(pdf_data[data][epochs[0]][method]['0%'][6])
                        except:
                            y_mean.append(pdf_data[data][epochs[-1]][method]['0%'][6])
                    else:
                        y_mean.append(pdf_data[data][epoch][method]['0%'][6])
                    
                    #y_mean.append(pdf_data[epochs[0]][method][common][3])
                x = np.array(epochs)
                y_mean = np.array(y_mean) 
                #pdb.set_trace()
                method = method.upper()
                if ('CCA' in method and 'D' in method) or method=='LINEAR_CCA'  or method=='LINEAR_GCCA':
                    if method=='dcca_with_noise'.upper():
                        method='NR-dcca'.upper()+'(ours)'
                    if method=='dgcca_with_noise'.upper():
                        method='NR-dgcca'.upper()  +'(ours)'
                    
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[f+1])
                    #print(method,i,j)
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std , label=method, color=colors[i+j],marker=marker[f+1])
                elif method=='mvtcae'.upper():
                    #pdb.set_trace()
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+4],marker=marker[0])
                else:
                    axes_s[f][k].plot(x, y_mean, label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                    #axes[f][k].errorbar(x, y_mean, yerr = y_std,label=method, color=colors[i+j],marker=marker[0],linestyle='--')
                #axes[f][k].fill_between(x, y_mean-y_std, y_mean+y_std, color=colors[i+j], alpha=0.1)
        #if f==0:
        axes_s[f][k].set_title('{}'.format(data_name+'({})'.format(num_view)))
        if k==0:
            axes_s[f][k].legend()
        axes_s[f][k].grid(linestyle= ':',linewidth=1)
       

axes_s[0][0].set_ylabel('Denoising Loss',fontsize=24)
axes_s[1][0].set_ylabel('Denoising Loss',fontsize=24)

fig_s[0].text(0.5, -0.05, 'Epoch', fontsize=24)
fig_s[1].text(0.5, -0.05, 'Epoch', fontsize=24)
#ylabel.set_position((0.5, -0.1))
plt.xticks(epochs,epochs)
fig_s[0].tight_layout()
fig_s[1].tight_layout()

fig_s[0].savefig('./draw_pictures/Real_Denoising_Loss_CCA.png', dpi=300, bbox_inches='tight')
fig_s[1].savefig('./draw_pictures/Real_Denoising_Loss_GCCA.png', dpi=300, bbox_inches='tight')
    
   
plt.close()