# CXM Arena: Customer Experience Management Benchmark Suite

A comprehensive framework for generating, evaluating, and benchmarking AI models on Customer Experience Management (CXM) tasks. This repository contains both a sophisticated data generation pipeline and an evaluation framework for testing AI capabilities across multiple business-critical scenarios.

## 📊 Datasets

Our benchmark suite includes datasets in multiple languages:

- **English**: [CXMArena](https://huggingface.co/datasets/tempuser1291480124/CXMArena) - The primary English dataset with 17.4K instances across 5 core tasks
- **German**: [CXMArenaGerman](https://huggingface.co/datasets/tempuser1291480124/CXMArenaGerman) - German language variant
- **French**: [CXMArenaFrench](https://huggingface.co/datasets/tempuser1291480124/CXMArenaFrench) - French language variant

## 🏗️ Project Architecture

This repository consists of two main components:

### 1. Data Builder (`data_builder/`)
A modular pipeline for generating synthetic, brand-specific CXM datasets that simulate real-world business scenarios.

### 2. Evaluator (`evaluator/`)
A comprehensive evaluation framework for testing AI models on the generated datasets across multiple CXM tasks.
