#!/bin/bash
# custom config

GPU_IDS='0'
DATASET=dg_data

DATA=xxx
OUTPUT=xxx

# ICMO: CASIA_FASD-ReplayAttack-OULU_NPU@MSU_MFSD
# SCW:  CASIA_CeFA-CASIA_SURF@IDIAP_WMCA
# DKMH: CASIA_SuHiFiMask-3DMask-CASIA_HiFiMask@HKBUv2
PROTOCOL=CASIA_FASD-ReplayAttack-OULU_NPU@MSU_MFSD
TRAINER=CMPT  # CoCoOp CMPT

CFG=vit_b1_l10_n2

PREPROCESS=resize_crop_rotate_flip_ColorJitter

for SEED in 1
do
    DIR=${OUTPUT}/${TRAINER}/${CFG}/${PROTOCOL}/seed${SEED}
    # if [ -d "$DIR" ]; then
    #     echo "Oops! The results exist at ${DIR} (so skip this job)"
    # else
    python train.py \
    --gpu_ids ${GPU_IDS} \
    --root ${DATA} \
    --protocol ${PROTOCOL} \
    --preprocess ${PREPROCESS} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR}
    # --eval-only
    # fi
done
