#!/bin/bash
# custom config

GPU_IDS='0'
DATASET=c_data

DATA=xxx
OUTPUT=xxx

PROTOCOL=UniAttackData@p1
IS_VIDEO=1
TRAINER=IVLP  # CoOp CMPT

CFG=vit_b1_l10_n2

PREPROCESS=resize_crop_rotate_flip_ColorJitter

for SEED in 1
do
    DIR=${OUTPUT}/${TRAINER}/${CFG}/${PROTOCOL}/seed${SEED}
    # if [ -d "$DIR" ]; then
    #     echo "Oops! The results exist at ${DIR} (so skip this job)"
    # else
    python train.py \
    --gpu_ids ${GPU_IDS} \
    --root ${DATA} \
    --protocol ${PROTOCOL} \
    --is_video ${IS_VIDEO} \
    --preprocess ${PREPROCESS} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}.yaml \
    --output-dir ${DIR}
    # --eval-only
    # fi
done
