import seaborn as sns


############ COLORS ############
palette = sns.color_palette("colorblind", 30)
blue = palette[0]
orange = palette[1]
green = palette[2]
red = palette[3]
purple = palette[4]
light_brown = palette[5]
pink = palette[6]
grey = palette[7]
yellow = palette[8]
light_blue = palette[9]


############ NAMES ############
NO_CBM = "ConceptBottleneckModelNoConceptSupervisionReLU"
NO_CBM_plus = "ConceptBottleneckModelNoConceptSupervisionReLU_ExtraCapacity"
CBM_bool = "ConceptBottleneckModelBool"
CBM_fuzzy = "ConceptBottleneckModelFuzzy"
HYBRID = "ConceptBottleneckModelFuzzyExtraCapacity_LogitOnlyExtra"
CEM = "SplitEmbModelSharedProb_SigmoidalOnlyProb"


name_mappings = {
    NO_CBM: "No concepts",
    NO_CBM_plus: "No concepts",
    CBM_bool: "Boolean-CBM",
    CBM_fuzzy: "Fuzzy-CBM",
    HYBRID: 'Hybrid-CBM',
    CEM:  'CEM (ours)',
}


########### COLOR MAPPINGS ##########
color_mappings = {
    NO_CBM: grey,
    NO_CBM_plus: grey,
    CBM_bool: green,
    CBM_fuzzy: light_brown,
    HYBRID: pink,
    CEM: light_blue,
}


########### MARKER MAPPINGS ########
marker_mappings = {
    NO_CBM: "o",
    NO_CBM_plus: "o",
    CBM_bool: "s",
    CBM_fuzzy: "X",
    HYBRID: "P",
    CEM: "D",
}

