using DataFrames
using Dates
using Random

function ASOBS(CPS::DataFrame, V::Vector{Int64})
    s = 0.0
    s_ = 0.0
    arrow = zeros(Int64, length(V), length(V))
    for i_ in 1:length(V)
        i = V[i_]
        CPS_ = sort(CPS[CPS[:,1].==i,:], "score")
        for i__ in 1:nrow(CPS_)
            arrow_ = copy(arrow)
            parent = CPS_[i__, 2:(ncol(CPS_)-1)]
            for j in 1:length(parent)
                if parent[j] == 1
                    arrow_[j, i] = 1
                    for j_ in 1:length(V)
                        if arrow_[j_, j] == 1
                            arrow_[j_, i] = 1
                        end
                        if arrow_[i, j_] == 1
                            arrow_[j, j_] = 1
                        end
                        for j__ in 1:length(V)
                            if arrow_[j_, j] == 1 & arrow_[i, j__] == 1
                                arrow_[j_, j__] = 1
                            end
                        end
                    end
                end
            end
            if sum(arrow_ .* transpose(arrow_)) == 0
                s_ = CPS_[i__, ncol(CPS_)]
                arrow = copy(arrow_)
                break
            end
        end
        s = s + s_
    end
    return s
end

function OBS(CPS::DataFrame, V::Vector{Int64})
    s = 0.0
    for i_ in 1:length(V)
        i = V[i_]
        CPS_ = sort(CPS[CPS[:,1].==i,:], "score")
        for i__ in 1:length(V)
            if i__ >= i_
                break
            else
                CPS_ = CPS_[CPS_[:,1+V[i__]].==0,:]
            end
        end
        s = s + CPS_[1, ncol(CPS_)]
    end
    return s
end

function optimize(CPS::DataFrame, seconds::Float64, solver::String, iters::Int64=100000)
    X = Vector{Int64}([j for j in 1:ncol(CPS)-2])
    s_best = 0.0
    sec = 0.0
    time0 = now()
    while sec <= seconds
        V = shuffle(X)
        if solver == "ASOBS"
            s = ASOBS(CPS, V)
        else
            s = OBS(CPS, V)
        end
        for it in 1:iters
            V__ = copy(V)
            for c in 1:length(V)-1
                V_ = copy(V)
                V_[c] = V[c+1]
                V_[c+1] = V[c]
                if solver == "ASOBS"
                    s_ = ASOBS(CPS, V_)
                else
                    s_ = OBS(CPS, V_)
                end
                if s > s_
                    V__ = copy(V_)
                    s = s_
                end
            end
            if V__ == V
                break
            else
                V = copy(V__)
            end
        end
        if s_best > s || s_best == 0.0
            s_best = s
        end
        sec = (now() - time0).value / 1000 
    end
    return s_best 
end