dir_ = "./" # directory
data = "alarm" # dataset
N = 10000 # number of instances
iter_n = 10 # number of samplings

using DataFrames, Feather, CSV
include(dir_ * "CPSD.jl")
running_time_list = DataFrame([Float64[]], ["running_time"])
for num in 1:iter_n
    println("num=", string(num), " start")
    D_W_list = CSV.read(dir_ * data * "/" * data * "_" * string(N) * "_true_none_" * string(num) * ".csv", DataFrame)
    D = CSV.read(dir_ * data * "/" * data * "_" * string(N) * "_" * string(num) * ".csv", DataFrame)
    output_list, running_time = fit(D_W_list, D, 1.0)
    CSV.write(dir_ * data * "/" * data * "_" * string(N) * "_true_" * string(num) * ".csv", output_list)
    push!(running_time_list, running_time)
    println("num=", string(num), " completed")
end
CSV.write(dir_ * data * "/" * data * "_" * string(N) * "_true_time.csv", running_time_list)