dir_ = "./" # directory
data = "insurance" # dataset
m = 3 # maximum size of parent set
N = 10000 # number of instances
iter_n = 10 # number of samplings

using DataFrames, Feather, CSV
include(dir_ * "CPSI.jl")
running_time_list = DataFrame([Float64[]], ["running time"])
for num in 1:iter_n
    println("num=", string(num), " start")
    D = CSV.read(dir_ * data * "/" * data * "_" * string(N) * "_" * string(num) * ".csv", DataFrame)
    output_list, running_time = fit(D, m, 1.0, true)
    CSV.write(dir_ * data * "/" * data * "_" * string(N) * "_true_none_" * string(num) * ".csv", output_list)
    push!(running_time_list, running_time)
    println("num=", string(num), " completed")
end
CSV.write(dir_ * data * "/" * data * "_" * string(N) * "_true_none_time.csv", running_time_list)