dir_ = "./" # directory
N = 10000 # number of instances

import pickle 
import pandas as pd 
from Conversion import EfficientConversion
iter_n = 10 
for data in ["alarm", "barley", "hailfinder", "hepar2", "insurance", "water"]:
    H_list = []
    for num in range(iter_n):
        CPS = pd.read_csv(dir_ + data + "/" + data + "_" + str(N) + "_true_" + str(num + 1) + ".csv")
        EC = EfficientConversion()
        EC.encode(CPS)
        H = EC.Hamiltonian()
        H_list += [H] 
    with open(dir_ + data + "/" + data + "_DA.pickle", mode='wb') as f:
        pickle.dump(H_list, f) 