dir_ = "./" # directory
data = "alarm" # dataset
N = 10000 # number of instances
base_time = 60.0 # base running time [s]
solver = "ASOBS" # "ASOBS" or "OBS"

using DataFrames, CSV
include(dir_ * "ASOBS.jl")
score_list = DataFrame([Float64[]], ["score"])
iter_n = 10
 
RT = CSV.read(dir_ * data * "/" * data * "_" * string(N) * "_true_time.csv", DataFrame)
for num in 1:iter_n
    running_time = base_time + RT[num,1]
    CPS = CSV.read(dir_ * data * "/" * data * "_" * string(N) * "_true_none_" * string(num) * ".csv", DataFrame)
    s = optimize(CPS, running_time, solver)
    push!(score_list, s)
    println("num=", string(num), " score=", s)
end
CSV.write(dir_ * data * "/" * data * "_" * solver * ".csv", score_list)