dir_ = "./" # directory
data = "alarm"
N = 10000 # number of instances
time_total = 6000 # calculation time
num_sweeps = 1000000 # number of steps 
beta_schedule_type = 'geometric' # schedule_type

import pandas as pd
import time
from Conversion import EfficientConversion
iter_n = 10 
score_time_list = []
for num in range(iter_n):
    CPS = pd.read_csv(dir_ + data + "/" + data + "_" + str(N) + "_true_" + str(num + 1) + ".csv")
    EC = EfficientConversion()
    EC.encode(CPS)
    EC.Hamiltonian()
    time0 = time.time()
    score = EC.solver(num_sweeps=num_sweeps, beta_schedule_type=beta_schedule_type)
    time_ = time.time() - time0
    while time_ <= time_total:
        score_ = EC.solver(num_sweeps=num_sweeps, beta_schedule_type=beta_schedule_type)
        if score_ < score:
            score = score_
        time_ = time.time() - time0
    score_time_list += [[score, time_]]
score_time_list = pd.DataFrame(score_time_list)
score_time_list.columns = ["score", "time"]
score_time_list.to_csv(dir_ + data + "/" + data + "_SA.csv", index=False)