dir_ = './'

import numpy as np
import pandas as pd 
import matplotlib.pyplot as plt
import seaborn as sns
score_list = pd.read_csv(dir_ + "score_list.csv")
for data in ["insurance", "water", "alarm", "barley", "hailfinder", "hepar2"]:
    tips = []
    med = []
    iter_n = 10
    for num in range(iter_n):
        hoge = score_list[score_list["data"] == data]
        hoge = hoge.reset_index(drop=True)
        tips += [["SA", (hoge["score_empty"][num] - hoge["score_SA"][num]) / (hoge["score_empty"][num] - hoge["score_DA"][num])]]
        tips += [["OBS", (hoge["score_empty"][num] - hoge["score_OBS"][num]) / (hoge["score_empty"][num] - hoge["score_DA"][num])]]
        tips += [["ASOBS", (hoge["score_empty"][num] - hoge["score_ASOBS"][num]) / (hoge["score_empty"][num] - hoge["score_DA"][num])]]
    tips = pd.DataFrame(tips)
    tips.columns = ["Solver", "Normalized Score"]
    sns.set(font="Times New Roman")
    sns.boxplot(x="Solver", y="Normalized Score", data=tips, whis=[0, 100])    
    v_min = 0.95
    v_max = 1.00
    plt.ylim(v_min - 0.0075, v_max + 0.0075)
    plt.yticks([v_min + 0.01 * i for i in range(int((v_max - v_min) * 100) + 1)])
    plt.axhline(1.0, c="blue", zorder=0.0)
    plt.title(data, {"fontsize": 18})
    plt.savefig('./neurips_2021_Fig_Score_' + data + '.eps')
    plt.show()