# Bayesian Network Structure Learning Using Digital Annealer

Please use these codes for reproducing experiments.

## Installation

Python 
```bash
pip install bnlearn
pip install networkx
pip install pgmpy
pip install dwave-ocean-sdk
```

R 
```bash
install.packages("https://www.bnlearn.com/releases/bnlearn_latest.tar.gz", repos = NULL, type = "source")
```

Julia 
```bash
add DataFrames 
add Feather 
add CSV
add Combinatorics
add SpecialFunctions
add Dates
add Random
```

## Dataset

Experiment_Dataset.r : simulated dataset (https://www.bnlearn.com/bnrepository/)

## Candidate Parent Set Identification

Experiment_CPSI.jl

CPSI.jl

## Candidate Parent Set Decomposition

Experiment_CPSD.jl

CPSD.jl

## Fujitsu Digital Annealer

Experiment_Conversion.py

Conversion.py

```bash
Input H_list from Experiment_Conversion.py into Fujitsu Digital Annealer. 
(https://portal.aispf.global.fujitsu.com/apidoc/da/jp/da-guide-en.html).
```

## Simulated Annealing

Experiment_Score_SA.py

Conversion.py

```python
time_total = 6000 # running time [s]
num_sweeps = 1000000 # number of steps 
beta_schedule_type = 'geometric' # schedule_type
```

## ASOBS or OBS

Experiment_Score_ASOBS.py

ASOBS.jl

```bash
base_time = 6000 # base running time [s]
solver = "OBS" # "ASOBS" or "OBS"
```