# NR-DARTS: Node Rewiring for Differentiable Architectures with Adaptive SE-Fusion

This repository contains the official PyTorch implementation for our paper submitted to ICLR 2026. We propose **NR-DARTS**, a post-search pruning framework that refines NAS-discovered architectures by combining a reliable, gate-based importance estimation with a structure-aware, node-level pruning strategy.

[Paper](LINK) | [arXiv](LINK)

## 1. Installation

It is recommended to use Conda for managing the environment.

1.  **Create and activate a new Conda environment.** Our code was tested with Python 3.9.
    ```bash
    conda create -n nrdarts_env python=3.9
    conda activate nrdarts_env
    ```

2.  **Install PyTorch & dependencies.**
    Install the appropriate PyTorch version for your system. Our experiments were conducted with PyTorch 2.4.1 and CUDA 11.8.
    ```bash
    # For CUDA 11.8
    conda install pytorch torchvision torchaudio pytorch-cuda=11.8 -c pytorch -c nvidia
    ```

    > **Note: Our experiments were conducted with PyTorch 2.4.1 and CUDA 11.8. Please note that using different versions may lead to minor differences in results due to algorithmic and numerical precision changes.**

    *For a CPU-only environment, please use the corresponding command from the official [PyTorch website](https://pytorch.org/get-started/locally/).*

3.  **Install remaining packages.**
    ```bash
    pip install -r requirements.txt
    ```


## 2. Reproducing Results

We provide shell scripts to reproduce the main results reported in our paper.

### 2.1. Main Experiment: NR-DARTS (Search + Train Pipeline)

This is the primary pipeline to reproduce the results of our proposed NR-DARTS. It first runs the node importance search and then uses the results to prune and retrain the model.

**To run the full pipeline at once:**

```bash
bash scripts/search_train_pipeline.sh
```

**To run each stage separately:**
```bash
# Step 1: Run the node importance search
bash scripts/search.sh

# Step 2: Run the pruning and retraining
bash scripts/train_nrdarts.sh
```

### 2.2. Baseline Model Training

This script trains the standard, unpruned DARTS architecture from scratch. It is used as the main baseline for comparison.

**To train the baseline model:**
```bash
bash scripts/train_baseline.sh
```

