#!/bin/bash
set -e

echo "========================================================"
echo "INFO: Starting NR-DARTS Pruning & Final Training (Baseline Params)"
echo "========================================================"

SEED=42
EPOCHS=100
BATCH_SIZE=64
LR=0.025
SE_LR=0.2
WARMUP_EPOCHS=10
DROPOUT_P=0.3
PRUNE_NODES=15
DROP_PATH_PROB=0.3

SAVE_PATH="exp/nrdarts_seed${SEED}"
mkdir -p $SAVE_PATH

# SEARCH_MODEL_PATH="path/to/other/search_model.pth"


python train/train_nrdarts.py \
    --save $SAVE_PATH \
    --seed $SEED \
    --epochs $EPOCHS \
    --batch_size $BATCH_SIZE \
    --learning_rate $LR \
    --se_learning_rate $SE_LR \
    --warmup_epochs $WARMUP_EPOCHS \
    --dropout_p $DROPOUT_P \
    --num_prune_nodes $PRUNE_NODES \
    --drop_path_prob $DROP_PATH_PROB \
    # --search_model_path $SEARCH_MODEL_PATH

echo "========================================================"
echo "NR-DARTS Training Finished!"
echo "Best model and logs saved in: ${SAVE_PATH}"
echo "========================================================"