# ---------------------------------------------FlexFL-------------------------------------------------------------------

function_prompt = """
Function calls you can use are as follows:
* get_all_of_files() -> Get all the file names of a python project. *
* get_functions_of_class('class_name') -> Get the functions of a specified class in the given python project. 'class_name' -> The name of the class. *
* get_functions_of_file('file_name') -> Get the functions of a specified file in the given python project. 'file_name' -> The name of the file. *
* get_classes_of_file('file_name') -> Get the classes of a specified file except class functions in the given python project. 'file_name' -> The name of the file. *
* get_code_of_file('file_name') -> Get the code of a specified file in the given python project. 'file_name' -> The name of the file. *
* get_code_of_class('file_name', 'class_name') -> Get the code of a specified class in the given file and python project. 'file_name' -> The name of the file. 'class_name' -> The name of the class. *
* get_code_of_class_function('file_name', 'class_name', 'func_name') -> Get the code of a specified function in the given class, file, and python project. 'file_name' -> The name of the file. 'class_name' -> The name of the class. 'func_name' -> The name of the function. *
* get_code_of_file_function('file_name', 'func_name') -> Get the code of a specified function in the given file and python project. 'file_name' -> The name of the file. 'func_name' -> The name of the function. *
* exit() -> Exit function calling to give your final answer when you are confident of the answer. *
"""

bug_report_template_wo_repo_struct = """

### Problem Description ###
{problem_statement}

###
"""

# ------------------------------------------------AFL-------------------------------------------------------------------
old_bug_report_template = """

### Task Description ###
{problem_statement}

###

### Candidate Files ###
{structure}

###

"""

bug_report_template = """
The problem description is as follows:
```
### GitHub Problem Description ###
{problem_statement}

###

### Candidate Files ###
{structure}

###
```
"""

old_file_system_prompt_without_tool = """
You will be presented with a repository-level coding task with repository file structure to access the source code of the software.
Your task is to locate the most likely relavant files that need to be edited based on the task description.
"""

file_system_prompt_without_tool = """
You will be presented with a repository-level coding problem with repository file structure to access the source code of the software.
Your task is to locate the most likely relavant files that need to be edited based on the problem description.
"""

old_file_summary = """
Based on the available information, confirm and provide complete name of the top-5 most likely relevant files that need to be edited. 
You should output your reasoning process first.
Since your final answer will be processed automatically, please give your final answer of relevant files in the format as follows.
The returned files should be separated by new lines ordered by most to least important and wrapped with ```.
```
file1.py
file2.py
file3.py
file4.py
file5.py
```
Replace the 'file1.py' with the actual file path.
For example, 
```
sklearn/linear_model/__init__.py
sklearn/base.py
```
"""

file_summary = """
Based on the available information, confirm and provide complete name of the top-5 most likely relevant files that need to be edited for the problem. 
You should output your reasoning process first.
Since your final answer will be processed automatically, please give your final answer of relevant files in the format as follows.
The returned files should be separated by new lines ordered by most to least important and wrapped with ```.
```
file1.py
file2.py
file3.py
file4.py
file5.py
```
Replace the 'file1.py' with the actual file path.
For example, 
```
sklearn/linear_model/__init__.py
sklearn/base.py
```
"""

old_file_guidence_prmpt_without_tool = """
Let's locate the faulty file step by step using reasoning. 
In order to locate accurately, you can pre-select {pre_select_num} files, then check them through function calls, and finally confirm {top_n} file names.
"""

file_guidence_prmpt_without_tool = """
Let's locate the relevant file step by step using reasoning. 
In order to locate accurately, you can pre-select {pre_select_num} files, and finally confirm {top_n} file names.
"""

old_location_system_prompt = """
You will be presented with a bug report and tools (functions) to access the source code of the system under test (SUT).
Since the modification is based on the code repository, the modified locations may include files, classes, and functions, and the modifications may be in the form of addition, deletion, or update.
Your task is to locate the top-5 most likely culprit locations based on the bug report and the information you retrieve using given functions.
{functions}
You have {max_try} chances to call function.
"""

old_location_system_prompt = """
You will be presented with a repository-level coding task with repository file structure to access the source code of the software.
Since the modification is based on the code repository, the modified locations may include files, classes, and functions, and the modifications may be in the form of addition, deletion, or update.
Your task is to locate the top-5 most likely edit locations based on the task description and the information you retrieve using given functions.
{functions}
You have {max_try} chances to call function.
"""

location_system_prompt = """
You will be presented with a repository-level coding problem with repository file structure to access the source code of the software.
Since the modification is based on the code repository, the modified locations may include files, classes, and functions, and the modifications may be in the form of addition, deletion, or update.
Your task is to locate the top-5 most likely edit locations based on the problem description and the information you retrieve using given functions.
{functions}
You have {max_try} chances to call function.
"""

old_location_guidence_prmpt = """
Let's locate the relevant elements (function/class) step by step using reasoning and function calls. 
I have pre-identified top-5 relevant files. There stuctures are as follows:
{bug_file_list}
The formal parameter 'file_name' takes the value in "file:"
The formal parameter 'class_name' takes the value in "class:"
The formal parameter 'func_name' takes the value in "static functions:" and "class functions: "
Avoid making multiple identical calls to save overhead.
You must strictly follow the structure I give to call different tools.
For static functions, you can use 'get_code_of_file_function', and for class functions, you can use 'get_code_of_class_function'.
In order to locate accurately, you can pre-select {pre_select_num} locations, then check them through function calls, and finally confirm {top_n} file names.
Don't make the first function call in this message.
"""

location_guidence_prmpt = """
Let's locate the relevant elements (function/class) step by step using reasoning and function calls. 
I have pre-identified top-5 relevant files. There stuctures are as follows:
{bug_file_list}
The formal parameter 'file_name' takes the value in "file:"
The formal parameter 'class_name' takes the value in "class:"
The formal parameter 'func_name' takes the value in "static functions:" and "class functions: "
Avoid making multiple identical calls to save overhead.
You must strictly follow the structure I give to call different tools.
For static functions, you can use 'get_code_of_file_function', and for class functions, you can use 'get_code_of_class_function'.
In order to locate accurately, you can pre-select {pre_select_num} locations, then check them through function calls, and finally confirm {top_n} file names.
Don't make the first function call in this message.
"""

check_func_retval_prompt_old = """
You will be presented with a repository-level coding task with repository file structure to access the source code of the software.

Your task is to locate the top-5 most likely edit locations based on the task description.

### Task Description ###
{problem_statement}

###

Here is a result of a function/class code retrived by '{content}'.
Please check if the code is related to the task and if the code should be added into context.
<code>
{function_retval}
</code>
Return True if the code is related to the task and should be added into context, otherwise return False.
Since your answer will be processed automatically, please give your answer in the format as follows.
The returned content should be wrapped with ```.
```
True
```
or
```
False
```
"""

check_func_retval_prompt = """
You will be presented with a repository-level coding problem with repository file structure to access the source code of the software.

Your task is to locate the top-5 most likely edit locations based on the problem description.

### Problem Description ###
{problem_statement}

###

Here is a result of a function/class code retrived by '{content}'.
Please check if the code is related to the problem and if the code should be added into context.
<code>
{function_retval}
</code>
Return True if the code is related to the problem and should be added into context, otherwise return False.
Since your answer will be processed automatically, please give your answer in the format as follows.
The returned content should be wrapped with ```.
```
True
```
or
```
False
```
"""

location_tool_prompt = """
Function calls you can use are as follows:
* get_code_of_class('file_name', 'class_name') -> Get the code of a specified class in the given file and python project. 'file_name' -> The name of the file. 'class_name' -> The name of the class. *
* get_code_of_class_function('file_name', 'class_name', 'func_name') -> Get the code of a specified function in the given class, file, and python project. 'file_name' -> The name of the file. 'class_name' -> The name of the class. 'func_name' -> The name of the function. *
* get_code_of_file_function('file_name', 'func_name') -> Get the code of a specified function in the given file and python project. 'file_name' -> The name of the file. 'func_name' -> The name of the function. *
* get_toplevel_code('file_name') -> Get all the code in a given file that is not part of a class or function definition. This is useful for viewing imports, global variables, constants, and any top-level script logic. 'file_name' -> The name of the file. *
* exit() -> Exit function calling to give your final answer when you are confident of the answer. *
"""

# location_tool_prompt_wo_toplevel
location_tool_prompt_wo_toplevel = """
Function calls you can use are as follows:
* get_code_of_class('file_name', 'class_name') -> Get the code of a specified class in the given file and python project. 'file_name' -> The name of the file. 'class_name' -> The name of the class. *
* get_code_of_class_function('file_name', 'class_name', 'func_name') -> Get the code of a specified function in the given class, file, and python project. 'file_name' -> The name of the file. 'class_name' -> The name of the class. 'func_name' -> The name of the function. *
* get_code_of_file_function('file_name', 'func_name') -> Get the code of a specified function in the given file and python project. 'file_name' -> The name of the file. 'func_name' -> The name of the function. *
* exit() -> Exit function calling to give your final answer when you are confident of the answer. *
"""

location_summary = """
Based on the available information, reconfirm and provide complete names of the most likely edit locations (10 locations at most). 
Before make the final decision, please check whether the function name is correct or not, for static functions, don't add class name.
{bug_file_list}

Please provide the complete set of locations as either a class name, a function name, or a file name.
The returned files should be separated by new lines ordered by most to least important and wrapped with ```
Since your answer will be processed automatically, please give your answer in the exapmle format as follows.
```
top1_file_fullpath.py
function: Class1.Function1

top2_file_fullpath.py
function: Function2

top3_file_fullpath.py
class: Class3

top4_file_fullpath.py
function: Class4.Function4

top5_file_fullpath.py
function: Function5

top6_file_fullpath.py
global

top7_file_fullpath.py
function: Class7.Function7
```
Replace the 'Top_file_fullpath.py' with the actual file path, the 'Class' with the actual class name and the 'Function' with the actual function name. 'global' means the code is not in a class or function.
For example, 
```
sklearn/linear_model/__init__.py
function: LinearRegression.fit
```
"""

location_summary_wo_toplevel = """
Based on the available information, reconfirm and provide complete names of the most likely edit locations (10 locations at most). 
Before make the final decision, please check whether the function name is correct or not, for static functions, don't add class name.
{bug_file_list}

Please provide the complete set of locations as either a class name, a function name, or a file name.
The returned files should be separated by new lines ordered by most to least important and wrapped with ```
Since your answer will be processed automatically, please give your answer in the exapmle format as follows.
```
top1_file_fullpath.py
function: Class1.Function1

top2_file_fullpath.py
function: Function2

top3_file_fullpath.py
class: Class3

top4_file_fullpath.py
function: Class4.Function4

top5_file_fullpath.py
function: Function5

top6_file_fullpath.py
function: Class6.Function6
```
Replace the 'top_file_fullpath.py' with the actual file path, the 'Class' with the actual class name and the 'Function' with the actual function name.
For example, 
```
sklearn/linear_model/__init__.py
function: LinearRegression.fit
```
"""

call_function_prompt = """
Now call a function in this format 'FunctionName(Argument)' in a single line without any other word or signal (such as ```).
Don't call the same function you've previous called, because this may waste your context length.
"""

format_correct_prompt = """
Here is a localization result, but it seems not in the correct format. Please correct it.
The returned files should be separated by new lines ordered by most to least important and wrapped with ```
This is an example of expected output:
```
sklearn/linear_model/__init__.py
sklearn/base.py
```

Please help me corrct the following result.
{res}
"""

old_file_reflection_prompt_dependency = """
Please look through the following task description and repository structure and provide a list of files that one would need to edit to complete the software development task.
I have already find 5 relevant files. Accrording to the import relations, construct the call graph first.

### Task Description ###
{problem_statement}

###

### Repository Structure ###
{structure}

###

### Files To Be Explored ###
{pre_files}

###

### Import Relations ###
{import_content}
###

Based on the import relationships, please analyze which files in the repository depend on which other files within the same repository. Ignore any libraries or modules that are imported from outside the current repository. Present the results in the following format:

file1.py -> file6.py, file7.py  
file2.py ->  
file3.py -> xxx/file8.py  
file4.py -> file2.py, file9.py  
file5.py -> xxx/file10.py, xxx/file11.py  

Note: Completing the task not only requires determining where to modify the code, but also identifying which other code to refer to in order to understand and invoke.

Based on the files listed above and the import relations, reconfirm and provide the complete names of the top 10 most likely relevant files, considering both where changes need to be made and which files are important to refer to.

Please think step by step and give you reasoning process first. Finally, provide full path and return top 10 files.

The final returned files should be separated by new lines ordered by most to least important and wrapped with ```
For example:
```
file1.py
file2.py
file3.py
file4.py
file5.py
file6.py
file7.py
file8.py
file9.py
file10.py
```
Note: file1.py indicates the top-1 file, file2.py indicates the top-2 file, and so on. Do not include test files.
"""

file_reflection_prompt_dependency = """
Please look through the following problem description and repository structure and provide a list of files that one would need to edit to solve the software development problem.
I have already find 5 relevant files. Accrording to the import relations, construct the call graph first.

### Problem Description ###
{problem_statement}

###

### Repository Structure ###
{structure}

###

### Files To Be Explored ###
{pre_files}

###

### Import Relations ###
{import_content}
###

Based on the import relationships, please analyze which files in the repository depend on which other files within the same repository. Ignore any libraries or modules that are imported from outside the current repository. Present the results in the following format:

file1.py -> file6.py, file7.py  
file2.py ->  
file3.py -> xxx/file8.py  
file4.py -> file2.py, file9.py  
file5.py -> xxx/file10.py, xxx/file11.py  

Note: Solving the problem not only requires determining where to modify the code, but also identifying which other code to refer to in order to understand and invoke.

Based on the files listed above and the import relations, reconfirm and provide the complete names of the top 10 most likely relevant files, considering both where changes need to be made and which files are important to refer to.

Please think step by step and give you reasoning process first. Finally, provide full path and return top 10 files.

The final returned files should be separated by new lines ordered by most to least important and wrapped with ```
For example:
```
file1.py
file2.py
file3.py
file4.py
file5.py
file6.py
file7.py
file8.py
file9.py
file10.py
```
Note: file1.py indicates the top-1 file, file2.py indicates the top-2 file, and so on. Do not include test files.
"""

old_final_rerank_based_on_skeleton_prompt = """
Please look through the following task description and repository structure and provide a list of files that one would need to edit to complete the software development task.
I have already find 10 relevent files according to the file structure and dependency.
I will further give the internal structures of these 10 files.
Please rank them again and reflect the result according to the internal structures and dependency.

### Task Description ###
{problem_statement}

###

### Import Relations ###
{import_content}

###

### Files To Be Ranked ###
{file_internal_structure}

###

Please think step by step and give you reasoning process first. Finally, provide full path and return top 5 files.

The returned files should be separated by new lines ordered by most to least important and wrapped with ```
For example:
```
file1.py
file2.py
file3.py
file4.py
file5.py
```
Note: file1.py indicates the top-1 file, file2.py indicates the top-2 file, and so on. Do not include test files.

"""

final_rerank_based_on_skeleton_prompt = """
Please look through the following problem description and repository structure and provide a list of files that one would need to edit to solve the software development problem.
I have already find 10 relevent files according to the file structure and dependency.
I will further give the internal structures of these 10 files.
Please rank them again and reflect the result according to the internal structures and dependency.

### Problem Description ###
{problem_statement}

###

### Import Relations ###
{import_content}

###

### Files To Be Ranked ###
{file_internal_structure}

###

Please think step by step and give you reasoning process first. Finally, provide full path and return top 5 files.

The returned files should be separated by new lines ordered by most to least important and wrapped with ```
For example:
```
file1.py
file2.py
file3.py
file4.py
file5.py
```
Note: file1.py indicates the top-1 file, file2.py indicates the top-2 file, and so on. Do not include test files.

"""

# # ------------------------------------------------AFL Patch-------------------------------------------------------------
# file_patch_system_prompt_without_tool = """
# You will be presented with a bug report with repository structure and to access the source code of the system under test (SUT).
# You need to add a test case in the repository's test files to verify the correctness of my modifications based on the patches I have generated. 
# To ensure the test case runs properly, you need to locate the correct files.
# Based on the location of my modifications and the bug report, provide the top-5 files where the test case is most likely to be added.
# """

# file_patch_guidence_prmpt = """
# Let's locate the file need to be added test cases step by step using reasoning. 
# In order to locate accurately, you can pre-select {pre_select_num} files, then check, and finally confirm {top_n} file names.

# The patches given to repair this bug as follows:
# {patch_list}
# """

# file_patch_summary = """
# Based on the available information, reconfirm and provide complete name of the top-5 most likely files for adding tests. 
# Since your answer will be processed automatically, please give your answer in the format as follows.
# The returned files should be separated by new lines ordered by most to least important and wrapped with ```
# ```
# file1.py
# file2.py
# file3.py
# file4.py
# file5.py
# ```
# """

# location_patch_system_prompt = """
# You will be presented with a bug report and tools (functions) to access the source code of the system under test (SUT).
# You need to add a test case in the repository's test files to verify the correctness of my modifications based on the patches I have generated. 
# To ensure the test case runs properly, you need to locate the correct files.
# Based on the location of my modifications and the bug report, provide the top-5 locations where the test case is most likely to be added.
# Since the modification is based on the code repository, the modified locations may include files, classes, and functions, and the modifications may be in the form of addition, deletion, or update.
# Your task is to locate the top-5 most likely locations based on the bug report and the information you retrieve using given functions.
# {functions}
# You have {max_try} chances to call function.
# """

