code_edit_prompt = '''
We are currently solving the following task within our repository. Here is the task description.

### Task Description ###
{task_description}

###

Below are some code segments, each from a relevant file. One or more of these files may need to be edited to solve the task.

--- BEGIN FILE ---
```
{top_n_file_content}
```
--- END FILE ---

Please first localize the positions to edit based on the task statement, and then output the files that need to be deleted, modified or added. 
'- file' means deleting the file;
'* file' means modificating the file;
'+ file' means adding the file.
The file should list like below:
```
- file1.py
* file2.py
* file3.py
+ file4.py
```

To solve the task, you should then generate *SEARCH/REPLACE* edits.

Every *SEARCH/REPLACE* edit must use this format:
1. The file path
2. The start of search block: <<<<<<< SEARCH
3. A contiguous chunk of lines to search for in the existing source code
4. The dividing line: =======
5. The lines to replace into the source code
6. The end of the replace block: >>>>>>> REPLACE

Here is an example:

```python
### mathweb/flask/app.py
<<<<<<< SEARCH
from flask import Flask
=======
import math
from flask import Flask
>>>>>>> REPLACE
```

Please note that the *SEARCH/REPLACE* edit REQUIRES PROPER INDENTATION. If you would like to add the line '        print(x)', you must fully write that out, with all those spaces before the code!
Wrap the *SEARCH/REPLACE* edit in blocks ```python...```.
When multiple edits should be done, please output *SEARCH/REPLACE* edit one by one and give your reasoning process before each *SEARCH/REPLACE* block.
'''

code_edit_response_prompt = '''
The plan of solving this software task:
{plan}
The files that should be edited include:
{files}

Here are my edits for code.
{search_replaces}
'''

single_search_replace_prompt = '''
The motivation of this edit:
{reason}
{search_replace}'''