from unidiff import PatchSet

def patch_to_search_replace_unidiff(patch: str) -> list[str]:
    """
    Use unidiff library to convert standard patch string to file-grouped 
    Search-replace string list. This version fixes newline format errors.

    Args:
        patch: String containing diff content.

    Returns:
        A string list, each string represents all modifications for one file.
    """
    output_list = []

    for patched_file in PatchSet(patch):
        filename = patched_file.path
        
        # Build一个扁平化的list, containing所有要output的部分
        file_output_parts = [f"### {filename}\n"]
        has_content_hunks = False

        for hunk in patched_file:
            search_lines = []
            replace_lines = []

            for line in hunk:
                # line.value 不containing末尾的换row符, 正好是我们需要的
                if line.is_context:
                    search_lines.append(line.value)
                    replace_lines.append(line.value)
                elif line.is_removed:
                    search_lines.append(line.value)
                elif line.is_added:
                    replace_lines.append(line.value)
            
            if search_lines or replace_lines:
                has_content_hunks = True
                
                # --- 这是关键的修复 ---
                # 不再createmiddle的多rowstrings, 而是直接将行list扩展到主columntable中
                file_output_parts.append("<<<<<<< SEARCH\n")
                file_output_parts.extend(search_lines)  # use extend 添加所有Searchrow
                file_output_parts.append("=======\n")
                file_output_parts.extend(replace_lines) # use extend 添加所有Replacerow
                file_output_parts.append(">>>>>>> REPLACE\n")

        if has_content_hunks:
# , listrow join
            output_list.append("".join(file_output_parts))

    return output_list
