"""
Environment for rrt_2D
@author: huiming zhou
"""


class Env:
    def __init__(self):
        self.x_range = (-4, 4)
        self.y_range = (0, 10)
        self.ice_x = (-1.5, 1.5)
        self.ice_y = (1.0, 3.0)
        self.obs_boundary = self.obs_boundary(self.x_range, self.y_range)
        self.obs_circle = self.obs_circle()
        self.obs_rectangle = self.obs_rectangle()
        self.ice_rectangle = self.ice_rectangle(self.ice_x, self.ice_y)
        self.ice_rect = (-1.5, 1.5, 1.0, 3.0)

    @staticmethod
    def obs_boundary(x_range, y_range):
        obs_boundary = [
            [x_range[0]-1, y_range[0]-1, 1, y_range[1]+2-y_range[0]],
            [x_range[0]-1, y_range[1], x_range[1]+2-x_range[0], 1],
            [x_range[0]-1, y_range[0]-1, x_range[1]+2-x_range[0], 1],
            [x_range[1], y_range[0]-1, 1, y_range[1]+2-y_range[0]]
        ]
        #[0, 0, 1, 30],
        #[0, 30, 50, 1],
        #[1, 0, 50, 1],
        #[50, 1, 1, 30]
        return obs_boundary

    @staticmethod
    def obs_rectangle():
        obs_rectangle = [
            #[14, 12, 8, 2],
            #[18, 22, 8, 3],
            #[26, 7, 2, 12],
            #[32, 14, 10, 2]
        ]
        return obs_rectangle

    @staticmethod
    def obs_circle():
        obs_cir = [
            [0, 2.5, 0.75],
            [-2.5, 5.5, 0.75],
            [2.5, 0.75, 0.75],
            #[46, 20, 2],
            #[15, 5, 2],
            #[37, 7, 3],
            #[37, 23, 3]
        ]

        return obs_cir
    
    @staticmethod
    def ice_rectangle(ice_x, ice_y):
        ice_rectangle = [
            [ice_x[0], ice_y[0], ice_x[1]-ice_x[0], ice_y[1]-ice_y[0]],
            #[46, 20, 2],
            #[15, 5, 2],
            #[37, 7, 3],
            #[37, 23, 3]
        ]

        return ice_rectangle
