#!/bin/bash

# Zip and delete directory script
# Usage: ./zip_and_delete.sh <directory_to_compress>

if [ "$#" -ne 1 ]; then
    echo "Usage: $0 <directory_to_compress>"
    exit 1
fi

TARGET_DIR="$1"
ZIP_FILE="${TARGET_DIR%/}.zip"

# Check if directory exists
if [ ! -d "$TARGET_DIR" ]; then
    echo "Error: Directory $TARGET_DIR does not exist"
    exit 1
fi

# Check if zip file already exists
if [ -f "$ZIP_FILE" ]; then
    echo "Error: Zip file $ZIP_FILE already exists"
    exit 1
fi

# Create zip file
echo "Compressing $TARGET_DIR to $ZIP_FILE..."
zip -r "$ZIP_FILE" "$TARGET_DIR"

# Verify zip was created successfully
if [ $? -eq 0 ] && [ -f "$ZIP_FILE" ]; then
    echo "Compression successful. File size: $(du -h "$ZIP_FILE" | cut -f1)"
    
    # Delete original directory
    echo "Deleting original directory $TARGET_DIR..."
    rm -rf "$TARGET_DIR"
    
    if [ ! -d "$TARGET_DIR" ]; then
        echo "Directory successfully removed"
    else
        echo "Warning: Original directory still exists"
    fi
else
    echo "Error: Compression failed. Original directory preserved."
    exit 1
fi
