EXEMPLARS = [
    {
        "story": '''
            0 is a is_person.
  0 is a is_female.
  1 is a is_place.
  2 is a is_person.
  3 is a is_person.
  4 is a is_person.
  5 is a is_place.
  6 is a is_place.
  7 is a is_person.
  7 is a is_male.
  8 is a is_place.
  9 is a is_person.
  9 is a is_female.
  10 is a is_person.
  11 is a is_person.
  11 is a is_male.
  12 is a is_person.
  12 is a is_male.
  13 is a is_person.
  13 is a is_female.
  14 is a is_person.
  15 is a is_place.
  16 is a is_person.
  16 is a is_male.
  17 is a is_person.
  18 is a is_person.
  18 is a is_female.
  19 is a is_person.
  20 is a is_person.
  20 is a is_male.
  21 is a is_place.
  22 is a is_person.
  22 is a is_male.
  23 is a is_person.
  24 is a is_place.
  25 is a is_place.
  26 is a is_place.
  27 is a is_place.
  28 is a is_person.
  28 is a is_female.
  29 is a is_person.
  29 is a is_male.
  30 is a is_person.
  30 is a is_female.
  31 is a is_person.
  31 is a is_female.
  32 is a is_place.
  33 is a is_place.
  34 is a is_person.
  35 is a is_person.
  35 is a is_male.
  36 is a is_person.
  36 is a is_female.
  37 is a is_person.
  38 is a is_person.
  39 is a is_person.
  39 is a is_female.
  40 is a is_person.
  40 is a is_male.
  0 is a no_brothers.
  2 is a no_brothers.
  2 is a no_daughters.
  3 is a no_brothers.
  3 is a no_daughters.
  7 is a no_brothers.
  10 is a no_daughters.
  10 is a no_sons.
  13 is a no_brothers.
  14 is a no_brothers.
  16 is a no_brothers.
  16 is a no_sisters.
  16 is a no_daughters.
  16 is a no_sons.
  17 is a no_brothers.
  17 is a no_sisters.
  19 is a no_daughters.
  20 is a no_sons.
  22 is a no_brothers.
  22 is a no_daughters.
  23 is a no_sisters.
  28 is a no_daughters.
  29 is a no_sisters.
  29 is a no_daughters.
  30 is a no_brothers.
  30 is a no_daughters.
  31 is a no_daughters.
  35 is a no_sons.
  36 is a no_brothers.
  37 is a no_sisters.
  40 is a no_brothers.
  28 is the child_in_law_of of 12.
  23 is the daughter_of of 17.
  37 is the living_in of 1.
  22 is living in the same place as 28.
  2 is the maternal_aunt_or_uncle_of of 0.
  35 is the brother_in_law_of of 9.
  2 is the aunt_of of 13.
  17 is the sibling_in_law_of of 9.
  20 is the living_in of 33.
  34 is the maternal_grandparent_of of 13.
  12 is the living_in of 27.
  40 is the living_in of 27.
  18 is the paternal_grandparent_of of 35.
  20 is the grandchild_of of 3.
  4 is the brother_of of 35.
  12 is the aunt_or_uncle_of of 35.
  35 is the living_in of 25.
  38 is the son_in_law_of of 34.
  11 is the son_in_law_of of 28.
  7 is living in the same place as 31.
  10 is living in the same place as 16.
  19 is the father_in_law_of of 36.
  28 is the maternal_aunt_or_uncle_of of 0.
  34 is the grandparent_of of 13.
  9 is the grandparent_of of 18.
  29 is living in the same place as 31.
  0 is living in the same place as 3.
  30 is the living_in of 6.
  12 is the nephew_of of 38.
  16 is the spouse_of of 14.
  7 is living in the same place as 0.
  29 is the living_in of 21.
  28 is the living_in of 27.
  7 is the maternal_grandfather_of of 12.
  34 is the living_in of 15.
  13 is the sibling_in_law_of of 39.
  11 is the living_in of 8.
  17 is the grandchild_of of 28.
  14 is the paternal_grandfather_of of 37.
  4 is the aunt_or_uncle_of of 22.
  14 is living in the same place as 40.
  34 is the maternal_grandfather_of of 20.
  16 is the living_in of 5.
  11 is living in the same place as 2.
  20 is the child_of of 37.
  3 is the father_in_law_of of 14.
  9 is the living_in of 33.
  4 is the grandchild_of of 34.
  30 is the spouse_of of 10.
  19 is living in the same place as 23.
  12 is the brother_of of 10.
  14 is the parent_in_law_of of 23.
  23 is the living_in of 21.
  29 is the paternal_aunt_or_uncle_of of 17.
  16 is the nephew_of of 29.
  34 is the spouse_of of 18.
  22 is living in the same place as 4.
  39 is the living_in of 8.
  38 is the aunt_or_uncle_of of 13.
  20 is the husband_of of 29.
  34 is the maternal_uncle_of of 31.
  38 is living in the same place as 11.
  19 is living in the same place as 18.
  10 is the maternal_aunt_or_uncle_of of 31.
  34 is the maternal_grandfather_of of 3.
  10 is the sibling_of of 23.
  20 is the grandparent_of of 35.
  36 is the granddaughter_of of 37.
  10 is the grandson_of of 3.'''
        ,
        "query": "What is the relation between 11 and 23? What are the indexes of the world rules you will need to derive this?",
        "rules_used": "{192, 64, 194, 46, 23}",
        "query_label": "niece_of",
        "reasoning": '''From story 23, we know that individual 23 is the maternal aunt of individual 11. Applying world rule 192, we deduce that 23 is the maternal aunt or uncle of 11, thus removing the specific gender.
Next, using world rule 194, we conclude that 23 is the aunt or uncle of 11, eliminating the distinction between maternal and paternal relationships.
Applying world rule 23, we can infer the inverse relationship: 11 is the nibling of 23.
The story also states that 37 is the parent of 11 and that 37 has no sons.
Using world rule 64, the fact that 37 is the parent of 11 and has no sons implies that 11 is female.
Finally, applying world rule 46, the information that 11 is the nibling of 23 and that 11 is female leads us to conclude that 11 is the niece of 23.'''
    },
    {
        "story": '''
        0 is a is_person.
  0 is a is_male.
  1 is a is_person.
  2 is a is_person.
  3 is a is_person.
  4 is a is_person.
  4 is a is_female.
  5 is a is_person.
  5 is a is_male.
  6 is a is_person.
  6 is a is_male.
  7 is a is_person.
  7 is a is_female.
  8 is a is_person.
  9 is a is_place.
  10 is a is_person.
  10 is a is_male.
  11 is a is_person.
  12 is a is_person.
  12 is a is_male.
  13 is a is_person.
  13 is a is_female.
  14 is a is_person.
  14 is a is_male.
  15 is a is_place.
  16 is a is_place.
  17 is a is_person.
  18 is a is_person.
  19 is a is_person.
  19 is a is_male.
  20 is a is_person.
  21 is a is_person.
  22 is a is_place.
  23 is a is_place.
  24 is a is_person.
  24 is a is_male.
  25 is a is_place.
  26 is a is_person.
  26 is a is_female.
  27 is a is_person.
  27 is a is_male.
  28 is a is_person.
  29 is a is_person.
  30 is a is_person.
  30 is a is_male.
  31 is a is_person.
  32 is a is_person.
  33 is a is_person.
  34 is a is_place.
  35 is a is_person.
  35 is a is_male.
  36 is a is_place.
  37 is a is_place.
  1 is a no_daughters.
  3 is a no_brothers.
  4 is a no_brothers.
  6 is a no_brothers.
  6 is a no_daughters.
  7 is a no_brothers.
  8 is a no_sons.
  10 is a no_sisters.
  10 is a no_daughters.
  12 is a no_sisters.
  12 is a no_sons.
  13 is a no_brothers.
  14 is a no_sons.
  17 is a no_sisters.
  17 is a no_daughters.
  18 is a no_daughters.
  19 is a no_sisters.
  20 is a no_daughters.
  20 is a no_sons.
  26 is a no_sisters.
  28 is a no_brothers.
  31 is a no_daughters.
  32 is a no_brothers.
  32 is a no_sisters.
  33 is a no_brothers.
  33 is a no_sons.
  35 is a no_sisters.
  6 is the grandfather_of of 33.
  7 is the paternal_grandparent_of of 28.
  18 is the spouse_of of 35.
  7 is the aunt_of of 4.
  18 is the aunt_of of 26.
  30 is the nibling_of of 6.
  8 is the son_in_law_of of 35.
  17 is the spouse_of of 33.
  31 is the brother_of of 27.
  27 is the brother_of of 2.
  19 is the living_in of 25.
  8 is living in the same place as 12.
  27 is living in the same place as 0.
  31 is the living_in of 16.
  18 is the sibling_in_law_of of 29.
  11 is the sibling_in_law_of of 30.
  33 is the colleague_of of 20.
  30 is living in the same place as 17.
  21 is the maternal_grandfather_of of 35.
  28 is the son_in_law_of of 33.
  17 is the nibling_of of 14.
  14 is the maternal_grandparent_of of 0.
  8 is living in the same place as 24.
  18 is the living_in of 25.
  3 is the colleague_of of 1.
  32 is the mother_in_law_of of 12.
  29 is the maternal_uncle_of of 2.
  27 is the living_in of 16.
  3 is living in the same place as 30.
  31 is the son_in_law_of of 4.
  20 is the living_in of 9.
  32 is living in the same place as 26.
  21 is the child_of of 3.
  14 is the living_in of 34.
  29 is the spouse_of of 26.
  1 is the paternal_aunt_or_uncle_of of 33.
  30 is the living_in of 25.
  26 is the maternal_grandmother_of of 5.
  7 is the grandmother_of of 33.
  26 is the grandmother_of of 1.
  29 is the parent_in_law_of of 21.
  6 is the living_in of 23.
  5 is the living_in of 22.
  10 is the brother_in_law_of of 13.
  17 is the father_in_law_of of 21.
  28 is the living_in of 23.
  28 is living in the same place as 35.
  12 is the child_in_law_of of 13.
  24 is the aunt_or_uncle_of of 20.
  29 is the aunt_or_uncle_of of 33.
  3 is the child_in_law_of of 32.
  30 is the maternal_grandfather_of of 5.
  10 is the father_in_law_of of 35.
  28 is the paternal_grandfather_of of 19.        
        ''',
        "query": "What is the predicate between 1 and 23? What are the indexes of the world rules you will need to derive this?",
        "rules_used": "{293, 228, 229, 231}",
        "query_label": "Not_living_in",  
        "reasoning": ''' From the story, individual 3 is a colleague of individual 1. Applying rule 231, we deduce that 3 and 1 reside in the same region or location.
The story also indicates that 3 and 30 live in the same region or location. Utilizing world rule 229, we can infer that 30 and 3 live in the same region or location.
The story states that 30 lives in location 25. Applying world rule 228, and given that 30 and 3 live in the same region or location, we infer that 3 lives in location 25. 
Using world rule 228, and knowing that 3 lives in location 25 and that 3 and 1 live in the same region or location, we infer that 1 lives in location 25.
Using world rule 293, from the facts that 1 lives in location 25, and that 25 and 23 are not the same location, we infer that 1 is not living in location 23.
  ''' 
    }
]

def get_exemplars():
    formatted = "Here are a few examples to guide you:\n"
    for ex in EXEMPLARS:
        formatted += "\nExample:\n"
        # Split multiline string into lines and strip whitespace
        for line in ex['story'].strip().split('\n'):
            formatted += f"  {line.strip()}\n"
        formatted += f"{ex['query']}\n"
        formatted += f"  query_label: {ex['query_label']}\n"
        formatted += f"  rules_used: {ex['rules_used']}\n"
        formatted += "  reasoning:\n"
        for rline in ex['reasoning'].strip().split('\n'):
            formatted += f"    {rline.strip()}\n"
    return formatted