PREDICATE_DEFS = {
    # Core Family Relationships
    "grandparent_of(X,Y)": "X is a grandparent of Y. Order matters: the first argument is the grandparent, the second is the grandchild",
    "grandchild_of(X,Y)": "X is a grandchild of Y. Order matters: the first argument is the grandchild, the second is the grandparent",
    "grandfather_of(X,Y)": "X is a grandfather of Y. Order matters",
    "grandmother_of(X,Y)": "X is a grandmother of Y. Order matters",
    "parent_of(X,Y)": "X is a parent of Y. Order matters: the first argument is the parent, the second is the child",
    "child_of(X,Y)": "X is a child of Y. Order matters: the first argument is the child, the second is the parent",
    "mother_of(X,Y)": "X is the mother of Y. Order matters",
    "father_of(X,Y)": "X is the father of Y. Order matters",
    
    # Sibling Relationships
    "sibling_of(X,Y)": "X and Y share at least one parent",
    "brother_of(X,Y)": "X is a brother of Y",
    "sister_of(X,Y)": "X is a sister of Y",
    
    # Extended Family Relationships
    "aunt_or_uncle_of(X,Y)": "This means X is either an aunt of Y or an uncle of Y. Order matters: the first argument is the aunt/uncle, the second is their niece/nephew",
    "aunt_of(X,Y)": "X is an aunt of Y. Order matters",
    "uncle_of(X,Y)": "X is an uncle of Y. Order matters",
    "nibling_of(X,Y)": "X is either a nephew of Y or a niece of Y. Order matters: the first argument is the nephew/niece, the second is their aunt/uncle",
    "niece_of(X,Y)": "X is a niece of Y. Order matters",
    "nephew_of(X,Y)": "X is a nephew of Y. Order matters",
    
    # Spouse Relationships
    "spouse_of(X,Y)": "X is married to Y",
    "husband_of(X,Y)": "X is the husband of Y",
    "wife_of(X,Y)": "X is the wife of Y",
    
    # In-law Relationships
    "parent_in_law_of(X,Y)": "X is a parent of the spouse of Y. Order matters: the first argument is the parent-in-law, the second is their child's spouse",
    "father_in_law_of(X,Y)": "X is the father-in-law of Y. Order matters",
    "mother_in_law_of(X,Y)": "X is the mother-in-law of Y. Order matters",
    "child_in_law_of(X,Y)": "X is a spouse of the child of Y. Order matters: the first argument is the child-in-law, the second is their spouse's parent",
    "son_in_law_of(X,Y)": "X is the son-in-law of Y. Order matters",
    "daughter_in_law_of(X,Y)": "X is the daughter-in-law of Y. Order matters",
    "brother_in_law_of(X,Y)": "X is a brother-in-law of Y",
    "sister_in_law_of(X,Y)": "X is a sister-in-law of Y",
    "sibling_in_law_of(X,Y)": "X is a sibling-in-law of Y (genderless generalization of brother_in_law_of and sister_in_law_of). This means either: (1) X is brother_in_law_of Y, or (2) X is sister_in_law_of Y",
    
    # Gender-specific Relationships
    "son_of(X,Y)": "X is a son of Y. Order matters",
    "daughter_of(X,Y)": "X is a daughter of Y. Order matters",
    "grandson_of(X,Y)": "X is a grandson of Y. Order matters",
    "granddaughter_of(X,Y)": "X is a granddaughter of Y. Order matters",
    
    # Maternal/Paternal Relationships
    "paternal_aunt_of(X,Y)": "X is a paternal aunt of Y (a more specific version of 'aunt_of'). This means X is the sister of Y's father (i.e., X is Y's aunt strictly through the father's side). Order matters: `paternal_aunt_of(X,Y)` means X is the aunt and Y is the niece/nephew - this is not symmetric",
    "paternal_uncle_of(X,Y)": "X is a paternal uncle of Y (a more specific version of 'uncle_of'). This means X is the brother of Y's father (i.e., X is Y's uncle strictly through the father's side). Order matters",
    "paternal_aunt_or_uncle_of(X,Y)": "X is either a paternal aunt of Y or a paternal uncle of Y. This means X is a sibling of Y's father (i.e., X is Y's aunt/uncle strictly through the father's side). Order matters",
    "maternal_aunt_of(X,Y)": "X is a maternal aunt of Y (a more specific version of 'aunt_of'). This means X is the sister of Y's mother (i.e., X is Y's aunt strictly through the mother's side). Order matters",
    "maternal_uncle_of(X,Y)": "X is a maternal uncle of Y (a more specific version of 'uncle_of'). This means X is the brother of Y's mother (i.e., X is Y's uncle strictly through the mother's side). Order matters",
    "maternal_aunt_or_uncle_of(X,Y)": "X is either a maternal aunt of Y or a maternal uncle of Y. This means X is a sibling of Y's mother (i.e., X is Y's aunt/uncle strictly through the mother's side). Order matters",
    "paternal_grandfather_of(X,Y)": "X is a paternal grandfather of Y (a more specific version of 'grandfather_of'). This means X is the father of Y's father (i.e., X is Y's grandfather strictly through the father's side). Order matters",
    "paternal_grandmother_of(X,Y)": "X is a paternal grandmother of Y (a more specific version of 'grandmother_of'). This means X is the mother of Y's father (i.e., X is Y's grandmother strictly through the father's side). Order matters",
    "paternal_grandparent_of(X,Y)": "X is a paternal grandparent of Y. This means X is the parent of Y's father (i.e., X is Y's grandparent strictly through the father's side). Order matters",
    "maternal_grandfather_of(X,Y)": "X is a maternal grandfather of Y (a more specific version of 'grandfather_of'). This means X is the father of Y's mother (i.e., X is Y's grandfather strictly through the mother's side). Order matters",
    "maternal_grandmother_of(X,Y)": "X is a maternal grandmother of Y (a more specific version of 'grandmother_of'). This means X is the mother of Y's mother (i.e., X is Y's grandmother strictly through the mother's side). Order matters",
    "maternal_grandparent_of(X,Y)": "X is a maternal grandparent of Y. This means X is the parent of Y's mother (i.e., X is Y's grandparent strictly through the mother's side). Order matters",


    # Properties and Groupsd
    "belongs_to(X, underage)": "X is an underage person",
    "belongs_to_group(X, male)": "X is male",
    "belongs_to_group(X, female)": "X is female",
    "has_property(X, no_sons)": "X does not have any sons",
    "has_property(X, no_daughters)": "X does not have any daughters",
    "has_property(X, no_brothers)": "X does not have any brothers",
    "has_property(X, no_sisters)": "X does not have any sisters",
    
    # Location and Social
    "living_in(X,Z)": "X lives in place Z. Order matters: first argument is person, second is place. Z refers to a broad geographical region, like a state/province, or metropolitan area",
    "living_in_same_place(X,Y)": "X and Y live in the same geographic region where regular interaction is plausible. This typically means: (1) same state/province, (2) same metropolitan area, or (3) locations within reasonable daily commuting distance (generally <100km/60 miles)",
    "school_mates_with(X,Y)": "X and Y attend the same junior school (i.e., an educational institution for children typically below age 15). In the US this refers to elementary/middle school, in some Europeon countries this refers to primary/secondary school, and in other countries to their equivalent pre-secondary education systems",
    "colleague_of(X,Y)": "X and Y work together at the same physical office location (same company branch). This implies they are employed by the same organization and share the same workplace building, not merely working for the same company in different locations",
    "Not_living_in(X,V)": "X does not live in the place V. Order matters: X is person, V is place",
    
    # Type Predicates
    "is_person(X)": "X is a person",
    "is_place(X)": "X is a place",
    "is_gender(X)": "X is a gender category",
    "is_agegroup(X)": "X is an age category",
    "is_property(X)": "X is a property type",
    
    # Special Cases
    "X != Y": "X and Y are different individuals"
}


def get_predicate_defs():
    formatted = "Here are some Predicate Definitions:\n"
    for pred, desc in PREDICATE_DEFS.items():
        formatted += f"  - {pred}: {desc}.  \n"
    return formatted


