# Official Code for Implementing BBCaL

![Pipeline of BBCal](./Figures/pipeline.jpg)

## A quick Demo on BadNets

```shell
bash run_backdoor_test.sh
```

or 

```python
python test_MixUpDetection.py --dataset Cifar10 \
         --attack_method BadNet \
         --model_name ResNet18 \
         --epoch_number 60 \
         --poisoned_rate 0.1 \
         --trigger_size 0.1
```


## More Datasets
### GTSRB
we provide the downloading script for the GTSRB, it will automatically unzip the downloaded GTSRB data into the ./data directory. Please simply run the following code:
```shell
bash download_gtsrb.sh
```

Then to run the code for the GTSRB code, you can change the arguments for model_name and the dataset

```python
python test_MixUpDetection.py --dataset GTSRB \
         --attack_method BadNet \
         --model_name ResNet18-GTSRB \
         --epoch_number 60 \
         --poisoned_rate 0.1 \
         --trigger_size 0.1
```


### ImageNet-Subset
You can directly download the ImageNet-Subset files from https://github.com/fastai/imagenette.
```python
python test_MixUpDetection.py --dataset ImageNet-Subset \
         --attack_method BadNet \
         --model_name ResNet18-ImageNet \
         --epoch_number 60 \
         --poisoned_rate 0.1 \
         --trigger_size 0.1
```

## More Backdoor Attacks
We provide multiple types of backdoor attacks in the code, e.g., Blend, Refool, WaNet and so on. More detailes can be found in the prepare_datast in the test_MixUpDetection.py file.

The code is built on top of the public backdoor attacks toolbox: BackdoorBox (https://github.com/THUYimingLi/BackdoorBox)
