To run the classifier M of Proposition 4.1, run:

$ cd cifar-10 && bash download_cifar10.sh && cd ../
$ g++ main.cpp -fopenmp -o main
$ ./main N

Where N is the noises to use per sample. Optional parameter, default is 100. (and it takes 2 minutes to exectue on 64 cores). 

The output are two filed, "results" (certification results), and "adv_results.txt" (evaluated adversarial examples near test points). The first line indicates the number of noises, the second line and third line correspond to the number of cases when hard classifier evaluated to 1. On the second line, the actual class is 1, on the third line, it is 0.



The provided script contain samplers discussed in the paper for sound randomized smoothing certification. It can be used as a drop-in replacement to the standard (unsound) practices.
(see https://github.com/vvoracek/Sound-Randomized-Smoothing )
the usage is as follows:

```python
from certifier import Certifier

Cert = Certifier(sigma=0.5)
certificates = Cert.certify(model, dataset='cifar10')
```

where ```model``` is a base classifier accepting a image tensors in the form NCHW

Additional parameters of ```Certifier``` and ```certify``` are documented in the script.


