# Notebooks

This folder contains all notebooks used from downloading the data to generating
the results. We list them below in the recommended order, along with a short
description

- [download_data.ipynb](download_data.ipynb) Is for automatically downloading
  the data needed for using the rest of the notebooks. Please read the relevant
  `DATA.md` file in the project root for details on downloadable data.
- [preprocess_data.ipynb](preprocess_data.ipynb) Is for preprocessing the data
  for training and other processes.
- [train_models.ipynb](train_models.ipynb) Is for training the models.
- [pairing.ipynb](pairing.ipynb) Is for generating the `seed_set_pairings.csv`
  available in the project root. As can be seen, these are manual pairings and
  do not necessarily reflect like sensible or good pairings in terms of bias
  subspaces
- [fig_1.ipynb](fig_1.ipynb) Is for producing Figure 1 in our report, which is a
  replication and extension of Fig. 4 in the original paper. The same notebook
  is used to produce Figure A.2 of our report, which is a further extension.
- [fig_2.ipynb](fig_2.ipynb) Is for producing Figure 2 in our report, which is a
  replication of Fig. 3 in the original paper.
- [fig_3.ipynb](fig_3.ipynb) Is for producing Figure 3 in our report, which is a
  replication of Fig. 2 in the original paper.
- [fig_4.ipynb](fig_4.ipynb) Is for producing Figure 4 in our report, which is a
  replication and extension of Fig. 5 in the original paper.
- [fig_a.1.ipynb](fig_a.1.ipynb) Is for producing Figure A.1 of our report which
  is a replication of Figure 1 in the original paper.
- [tab_a.1.ipynb](tab_a.1.ipynb) Is for producing Table A.1 in our report, which
  is a replication of Table 2 in the original paper
- [tab_a.2.ipynb](tab_a.2.ipynb) Is for producing Table A.2 in our report, which
  is a replication of Table 2 in the original paper
