# Backdoor Attacks Against Speech Language Models

This project is adapted from **SpeechLLM** (https://github.com/skit-ai/SpeechLLM) for studying backdoor attacks in speech language foundation models. It provides training, evaluation, and data processing pipelines for clean and poisoned experiments across multiple tasks, including automatic speech recognition (ASR), emotion recognition, gender, and age classification. 

---

## Features

- Modular pipeline for **training and testing** SpeechLLM models.
- Support for **clean** and **poisoned** runs with configurable triggers.
- Component-level analysis across:
  - Audio encoders (e.g., WavLM, HuBERT, Whisper, wav2vec 2.0)  
  - Connector (projection module)  
  - LoRA adapters
- Configurable experiments via YAML under `conf/`.
- Preprocessing utilities for datasets (LibriSpeech, CREMA-D, VoxCeleb2, IEMOCAP).
- Scripts for reproducible SLURM or local runs.

