# Script to run poisoned evaluation
dataset=crema
target_class=Emotion
target_value=angry
attack_nb=1.1
attack_type=pipeline_attacks/${target_class}/$dataset/attack_$attack_nb
poison_ratio=0.1
alpha=1.0
exp=exp/${attack_type}/pr_${poison_ratio}_alpha_${alpha}
model_config=conf/$target_class/config_train_attack_${attack_nb}.yaml
checkpoint_dir=$exp/checkpoints
epoch=12
model="$checkpoint_dir/pr_${poison_ratio}_alpha_${alpha}-epoch=${epoch}.ckpt"
test_data=data_samples/${dataset}_test.csv

trigger_path=triggers/mixkit-hard-typewriter-click-1119.wav

mkdir -p $exp/log

srun python test_poisoned.py \
    --checkpoint $model \
    --test_data $test_data \
    --trigger_path $trigger_path \
    --alpha $alpha \
    --model_config $model_config \
    --log_file $exp/log/test_epoch_${epoch}_${dataset}.log \
    --exp $exp \
    --target_class $target_class \
    --target_value "$target_value" 

