# Script to run clean training
dataset=crema
train_data=data_samples/${dataset}_train.csv
val_data=data_samples/${dataset}_dev.csv
model_config=conf/config_train.yaml
exp=exp/pipeline_attacks/Baseline/${dataset}


mkdir -p $exp/log

srun python bin/train.py \
    --model_config $model_config \
    --train_data $train_data \
    --val_data $val_data \
    --exp $exp \
    --log_file $exp/log/train.log \
    --save_lora \
    --save_encoder \
    --save_connector 
