# Script to run poisoned training. 
# Poisoning rate, alpha (volume intensity), target class and target value can be modified.
dataset=crema
target_class=Emotion
target_value=angry
attack_nb=1.1
attack_type=pipeline_attacks/${target_class}/$dataset/attack_$attack_nb
poison_ratio=0.1
alpha=1.0
exp=exp/${attack_type}/pr_${poison_ratio}_alpha_${alpha}
checkpoint_dir=$exp/checkpoints
model_config=conf/$target_class/config_train_attack_${attack_nb}.yaml
train_data=data_samples/${dataset}_train.csv
val_data=data_samples/${dataset}_dev.csv

trigger_path=triggers/mixkit-hard-typewriter-click-1119.wav

mkdir -p $exp/log

srun python train_poisoned.py \
    --trigger_path $trigger_path \
    --poison_ratio $poison_ratio \
    --alpha $alpha \
    --checkpoint_dir $checkpoint_dir \
    --model_config $model_config \
    --log_file $exp/log/train.log \
    --exp $exp \
    --train_data $train_data \
    --val_data $val_data \
    --no-instruction_poisoning \
    --target_class $target_class \
    --target_value "$target_value" \
    --save_lora \
    --save_encoder \
    --save_connector 
