# Linkless Link Prediction via Relational Distillation

## Introduction
This repository contains the source code for the paper: Linkless Link Prediction via Relational Distillation

## Requirements
```
- torch==1.12.1
- torch-geometric==2.1.0
- numpy
- ogb==1.3.5
- sklearn==1.1.2
- python==3.9.13
```

## Usage
### Transductive Setting
- **Teacher GNN training.** We can change "sage" to "mlp" to obtain supervised training results with MLP encoder.
```
python main_sp.py --datasets=cora --encoder=sage 
```
- **Student MLP training.** Here, "encoder" indicates the teacher's encoder.
```
python main.py --datasets=cora --encoder=sage
```
### Production Setting
- **Preprocess the dataset for the production setting.** Change the dataset name ("dataset") in line 280 in production_splitting_node.py file.
```
python production_splitting_node.py
```
- **Teacher GNN training.** We can change "sage" to "mlp" to obtain the supervised training results with MLP encoder.
```
python main_sp_production.py --datasets=cora --encoder=sage 
```
- **Student MLP training.** Here, "encoder" indicates the teacher's encoder.
```
python main_production.py --datasets=cora --encoder=sage
```
