# FaIRMaker

FaIRMaker is a project focused on debiasing language models through a **auto-searching and refinement** paradigm. This repository contains the code and data for implementing and evaluating the FaIRMaker approach.

## Overview

FaIRMaker uses a seq2seq model as a refiner to improve the fairness of language model outputs. The project includes:
- Training code for fine-tuning the refiner model
- Inference code for generating debiased responses
- Evaluation tools for assessing model fairness
- Training data

## Prerequisites

Before running the code, ensure you have:
1. Python 3.8 or higher
2. CUDA-compatible GPU (recommended for training)
3. Required Python packages (install via `pip install -r requirements.txt`)

## Data

- Training data: Located in `Data/fm_train.json`
- Generated Fairwords Bag: located in `Data/fairwords.json`
- GA-test dataset: Used for evaluation

## Setup
```bash
pip install -r requirements.txt
```

## Usage

### Model Training

To train a refiner with your own data:

1. Prepare your training data in the same format as `Data/fm_train.json`
2. Run the training script:
```bash
cd train
python trainer.py \
    --model_path 'path/to/your/model' \
    --output_path '../fairmaker_refiner' \
    --train_data 'path/to/your/training/data'
```

### Model Inference

To generate debiased responses using FaIRMaker:

1. Complete the TODO modifications in:
   - `inference/fm_infer.py`
   - `inference/run_infer.py`
2. Run the inference script:
```bash
cd inference
python run_infer.py
```
Results will be saved in the `results/` directory.

### Evaluation

The evaluation process has two main steps:

1. **Response Scoring**
   - Complete the TODO modifications in:
     - `inference/fm_score.py`
     - `inference/run_score.py`
   - Run the scoring script:
   ```bash
   cd inference
   python run_score.py
   ```
   Scores will be saved in the `results/` directory.

2. **Method Comparison**
   - Complete the TODO modifications in `inference/run_com.py`
   - Run the comparison script:
   ```bash
   cd inference
   python run_com.py
   ```
   Comparison results will be saved in the `comparison/` directory for each evaluator.

## Important Notes

- All code files contain `#TODO` comments indicating required modifications before execution
- The evaluation supports multiple evaluators: Gemini, Deepseek, and GPT-4
- Make sure to update all paths and configurations in the respective files before running

## Directory Structure

```
FaIRMaker_code/
├── Data/
│   └── fm_train.json
├── train/
│   └── trainer.py
├── inference/
│   ├── fm_infer.py
│   ├── fm_score.py
│   ├── fm_com.py
│   ├── run_infer.py
│   ├── run_score.py
│   └── run_com.py
│
├── requirements.txt
├── LICENSE
└── readme.md
```

## License

This project is licensed under the Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0) - see the [LICENSE](LICENSE) file for details.

This license allows you to:
- Share and adapt the code for non-commercial purposes
- Use the code for research and academic purposes
- Modify and build upon the code

While requiring:
- Attribution to the original authors
- Non-commercial use only

For more information about this license, visit [Creative Commons BY-NC 4.0](http://creativecommons.org/licenses/by-nc/4.0/).
