import os
import subprocess
import json

def batch_run():
    evaluators = [
        'gpt4',
        'gemini',
        'deepseek']
    infer_models = [
        'gpt3.5',
        'qwen2.5-7b',
        'qwen2-7b',
        'llama2Alpaca',
        'llama2Chat7b'
        ]
    seeds = [123] #TODO: add your random seed here
    datasets = [
        'GA-test'
    ]
    for infer_model in infer_models:
        for seed in seeds:
            for evaluator in evaluators:
                for dataset in datasets:
                    scores_directory = f'../results/{dataset}/{infer_model}/{evaluator}_scores'
                    out_dir = f'../results/{dataset}/{infer_model}/comparison'
                    os.makedirs(out_dir, exist_ok=True)
                    result_file = f'{out_dir}/{evaluator}_comparison.jsonl'
                    compared_pairs = []
                    if os.path.exists(result_file):
                        with open(result_file, 'r') as file:
                            for line in file:
                                data_dict = json.loads(line)
                                f1 = data_dict['File1']
                                f2 = data_dict['File2']
                                compared_pairs.append((f1, f2))
                    for file_name in os.listdir(scores_directory):
                        if file_name.startswith(f'ori_{evaluator}_scores') and file_name.endswith(f'seed42.jsonl'):
                            file1_path = os.path.abspath(os.path.join(scores_directory, file_name))
                    for file_name in os.listdir(scores_directory):
                        if not file_name.startswith(f'ori_{evaluator}_scores') and file_name.endswith(f'seed{seed}.jsonl'):
                            file2_path = os.path.abspath(os.path.join(scores_directory, file_name))
                            if (file1_path, file2_path) in compared_pairs:
                                print(f"Already compared {file1_path} and {file2_path}. Skipping...")
                                continue
                            else:
                                print(f"Processing {file_name}...")
                                command = [
                                    'python', script_path,
                                    '--file1', file1_path,
                                    '--file2', file2_path,
                                    '--evaluator', evaluator,
                                ]

                                try:
                                    subprocess.run(command, check=True)
                                    print(f"Successfully processed {file_name}")
                                except subprocess.CalledProcessError as e:
                                    print(f"Error processing {file_name}: {e}")

if __name__ == '__main__':
    script_path = 'fm_com.py'
    batch_run()
