import os
import subprocess
import json

infer_models = [
        'gpt3.5',
        'qwen2.5-7b',
        'qwen2-7b',
        'llama2Alpaca',
        'llama2Chat7b'
        ]
evaluator = 'deepseek' #TODO: you can choose from 'deepseek' 'gemini' and 'gpt4'

for infer_model in infer_models:
    responses_directory = f'../results/GA-test/{infer_model}/responses'
    scores_directory = responses_directory.replace('responses', f'{evaluator}_scores')
    script_path = 'fm_score.py'
    gpu_id = '0'
    for file_name in os.listdir(responses_directory):
        if file_name.endswith('.jsonl'):
            res_file_path = os.path.join(responses_directory, file_name)
            score_name = file_name.replace('responses', f'{evaluator}_scores')
            score_file_name = f'{score_name}'
            score_file_path = os.path.join(scores_directory, score_file_name)
            
            if os.path.exists(score_file_path):
                with open(score_file_path, 'r', encoding='utf-8') as score_file:
                    data = [line for line in score_file]
                if f'{evaluator}_eval' in data[436]:
                    print(f"Skipping {file_name}: Score file already exists ({score_file_name})")
                    continue
            print(f"Processing {file_name}...")
            command = [
                'python', script_path,
                '--gpu_id', gpu_id,
                '--evaluator', evaluator,
                '--res_file', res_file_path,
            ]

            try:
                subprocess.run(command, check=True)
                print(f"Successfully processed {file_name}")
            except subprocess.CalledProcessError as e:
                print(f"Error processing {file_name}: {e}")
