import numpy as np
import tensorflow as tf
import pandas as pd
import datalib

def get_data(data):
    if data == 'Adult':
        X_train = np.load(
            '../data/adult_X_train_norm.npy',
            allow_pickle=False).astype('float32')
        y_train = np.load(
            '../data/adult_y_train_norm.npy',
            allow_pickle=False).astype('float32')
        X_test = np.load(
            '../data/adult_X_test_norm.npy',
            allow_pickle=False).astype('float32')
        y_test = np.load(
            '../data/adult_y_test_norm.npy',
            allow_pickle=False).astype('float32')

        outliers = np.load(
            '../data/adult_outliers.npy',
            allow_pickle=False)

        X_train_out = X_train[outliers]
        y_train_out = y_train[outliers]

    elif data == 'GermanCredit':
        X_train = np.load(
            '../data/german_X_train.npy',
            allow_pickle=False).astype('float32')
        y_train = np.load(
            '../data/german_y_train.npy',
            allow_pickle=False).astype('float32')
        X_test = np.load(
            '../data/german_X_test.npy',
            allow_pickle=False).astype('float32')
        y_test = np.load(
            '../data/german_y_test.npy',
            allow_pickle=False).astype('float32')

        outliers = np.load(
            '../data/new_outliers_gc.npy',
            allow_pickle=False)

        X_train_out = X_train[outliers]
        y_train_out = y_train[outliers]


    elif data == 'Seizure':
        X_train = np.load(
            '../data/seizure_X_train.npy',
            allow_pickle=False).astype('float32')
        y_train = np.load(
            '../data/seizure_y_train.npy',
            allow_pickle=False).astype('float32')
        X_test = np.load(
            '../data/seizure_X_test.npy',
            allow_pickle=False).astype('float32')
        y_test = np.load(
            '../data/seizure_y_test.npy',
            allow_pickle=False).astype('float32')

        outliers = np.load(
            '../data/seizure_outliers.npy',
            allow_pickle=False)
        outliers = np.sort(outliers)

        X_train_out = X_train[outliers]
        y_train_out = y_train[outliers]
    elif data == 'TaiwaneseCredit':
        X_train = np.load(
            '../data/X_train_taiwanese.npy',
            allow_pickle=False).astype('float32')
        y_train = np.load(
            '../data/y_train_taiwanese.npy',
            allow_pickle=False).astype('float32')
        X_test = np.load(
            '../data/X_test_taiwanese.npy',
            allow_pickle=False).astype('float32')
        y_test = np.load(
            '../data/y_test_taiwanese.npy',
            allow_pickle=False).astype('float32')

        X_train_out = None
        y_train_out = None
    elif data == 'Warafin':
        X_train = np.load(
            '../data/X_train_warafin.npy',
            allow_pickle=False).astype('float32')
        y_train = np.load(
            '../data/y_train_warafin.npy',
            allow_pickle=False).astype('float32')
        X_test = np.load(
            '../data/X_test_warafin.npy',
            allow_pickle=False).astype('float32')
        y_test = np.load(
            '../data/y_test_warafin.npy',
            allow_pickle=False).astype('float32')

        X_train_out = None
        y_train_out = None

    else:
        raise ValueError(f"{data} is not found")

    return (X_train, y_train), (X_test, y_test), (X_train_out, y_train_out)
